/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.io.modbus;

import net.solarnetwork.node.io.modbus.ModbusFunction;
import net.solarnetwork.node.io.modbus.ModbusReadFunction;
import net.solarnetwork.node.io.modbus.ModbusRegisterBlockType;

public enum ModbusWriteFunction implements ModbusFunction
{
    WriteCoil(5, ModbusRegisterBlockType.Coil),
    WriteHoldingRegister(6, ModbusRegisterBlockType.Holding),
    WriteMultipleCoils(15, ModbusRegisterBlockType.Coil),
    WriteMultipleHoldingRegisters(16, ModbusRegisterBlockType.Holding);

    private final int code;
    private final ModbusRegisterBlockType blockType;

    private ModbusWriteFunction(int code, ModbusRegisterBlockType blockType) {
        this.code = code;
        this.blockType = blockType;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String toDisplayString() {
        return this.toString().replaceAll("([a-z])([A-Z])", "$1 $2") + " (" + this.code + ")";
    }

    public static ModbusWriteFunction forCode(int code) {
        for (ModbusWriteFunction e : ModbusWriteFunction.values()) {
            if (code != e.code) continue;
            return e;
        }
        throw new IllegalArgumentException("Unknown ModbusWriteFunction code [" + code + "]");
    }

    @Override
    public boolean isReadFunction() {
        return false;
    }

    @Override
    public ModbusFunction oppositeFunction() {
        switch (this) {
            case WriteCoil: 
            case WriteMultipleCoils: {
                return ModbusReadFunction.ReadCoil;
            }
            case WriteHoldingRegister: 
            case WriteMultipleHoldingRegisters: {
                return ModbusReadFunction.ReadHoldingRegister;
            }
        }
        return null;
    }

    @Override
    public ModbusRegisterBlockType blockType() {
        return this.blockType;
    }
}

