/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.io.modbus.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import net.solarnetwork.node.io.modbus.ModbusConnection;
import net.solarnetwork.node.io.modbus.ModbusConnectionAction;
import net.solarnetwork.node.io.modbus.ModbusNetwork;
import net.solarnetwork.node.io.modbus.support.LockingModbusConnection;
import net.solarnetwork.node.service.LockTimeoutException;
import net.solarnetwork.service.support.BasicIdentifiable;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.support.BasicTextFieldSettingSpecifier;
import net.solarnetwork.settings.support.BasicToggleSettingSpecifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractModbusNetwork
extends BasicIdentifiable
implements ModbusNetwork {
    public static final long DEFAULT_RETRY_DELAY_MILLIS = 60L;
    public static final String DEFAULT_UID = "Modbus Port";
    public static final long DEFAULT_TIMEOUT_SECS = 10L;
    public static int DEFAULT_RETRIES = 3;
    public static boolean DEFAULT_HEADLESS = true;
    public static boolean DEFAULT_RETRY_RECONNECT = false;
    private long timeout = 10L;
    private TimeUnit timeoutUnit = TimeUnit.SECONDS;
    private boolean headless = DEFAULT_HEADLESS;
    private int retries = DEFAULT_RETRIES;
    private long retryDelay = 60L;
    private TimeUnit retryDelayUnit = TimeUnit.MILLISECONDS;
    private boolean retryReconnect = DEFAULT_RETRY_RECONNECT;
    private Set<String> classNamesToTreatAsIoException = AbstractModbusNetwork.defaultClassNamesToTreatAsIoException();
    private final ReentrantLock lock = new ReentrantLock(true);
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    private static final Set<String> defaultClassNamesToTreatAsIoException() {
        return Collections.singleton("net.wimpi.modbus.ModbusIOException");
    }

    public AbstractModbusNetwork() {
        this.setUid(DEFAULT_UID);
    }

    protected final Set<String> getClassNamesToTreatAsIoException() {
        return this.classNamesToTreatAsIoException;
    }

    protected final Set<String> addClassNamesToTreatAsIoException(Iterable<String> classNames) {
        if (classNames == null) {
            return this.classNamesToTreatAsIoException;
        }
        Set<String> s = new LinkedHashSet<String>(this.classNamesToTreatAsIoException);
        for (String name : classNames) {
            s.add(name);
        }
        s = Collections.unmodifiableSet(s);
        this.classNamesToTreatAsIoException = s;
        return s;
    }

    protected final Set<String> removeClassNamesToTreatAsIoException(Iterable<String> classNames) {
        if (classNames == null) {
            return this.classNamesToTreatAsIoException;
        }
        Set<String> s = new LinkedHashSet<String>(this.classNamesToTreatAsIoException);
        for (String name : classNames) {
            s.remove(name);
        }
        s = Collections.unmodifiableSet(s);
        this.classNamesToTreatAsIoException = s;
        return s;
    }

    private final boolean shouldConvertToIoException(Throwable t) {
        Class<?>[] classes;
        for (Class<?> c : classes = t.getClass().getClasses()) {
            if (!this.classNamesToTreatAsIoException.contains(c.getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T performAction(int unitId, ModbusConnectionAction<T> action) throws IOException {
        ModbusConnection conn = null;
        try {
            conn = this.createConnection(unitId);
            if (conn == null) {
                T t = null;
                return t;
            }
            conn.open();
            T t = action.doWithConnection(conn);
            return t;
        }
        catch (RuntimeException e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            this.log.warn("{} performing action {} on device {}", new Object[]{t.getClass().getSimpleName(), action, unitId});
            if (this.shouldConvertToIoException(t)) {
                throw new IOException(t.getMessage(), t);
            }
            if (!(t instanceof RuntimeException)) throw e;
            throw (RuntimeException)t;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (RuntimeException runtimeException) {}
            }
        }
    }

    protected void acquireLock() throws LockTimeoutException {
        String desc = this.getNetworkDescription();
        if (this.lock.isHeldByCurrentThread()) {
            this.log.debug("Port {} lock already acquired", (Object)desc);
            return;
        }
        long timeout = this.getTimeout();
        this.log.debug("Acquiring lock on Modbus port {}; waiting at most {} {}", new Object[]{desc, timeout, this.getTimeoutUnit()});
        try {
            long ts = System.currentTimeMillis();
            if (this.lock.tryLock(timeout, this.getTimeoutUnit())) {
                if (this.log.isDebugEnabled()) {
                    long t = System.currentTimeMillis() - ts;
                    this.log.debug("Acquired port {} lock in {}ms", (Object)desc, (Object)t);
                }
                return;
            }
            if (this.log.isDebugEnabled()) {
                long t = System.currentTimeMillis() - ts;
                this.log.debug("Timeout acquiring port {} lock after {}ms", (Object)desc, (Object)t);
            }
        }
        catch (InterruptedException e) {
            this.log.debug("Interrupted waiting for port {} lock", (Object)desc);
        }
        throw new LockTimeoutException(String.format("Could not acquire port %s lock within %d %s", desc, timeout, this.getTimeoutUnit().toString().toLowerCase()));
    }

    protected void releaseLock() {
        if (this.lock.isHeldByCurrentThread()) {
            String desc = this.getNetworkDescription();
            this.log.debug("Releasing lock on {}", (Object)desc);
            this.lock.unlock();
        }
    }

    protected ModbusConnection createLockingConnection(ModbusConnection connection) {
        return new LockingModbusConnection(connection, this.lock, this.timeout, this.timeoutUnit, this.getNetworkDescription(), this.log);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.getNetworkDescription() + '}';
    }

    protected String getNetworkDescription() {
        return this.toString();
    }

    protected List<SettingSpecifier> getBaseSettingSpecifiers() {
        ArrayList<SettingSpecifier> results = new ArrayList<SettingSpecifier>(5);
        results.add((SettingSpecifier)new BasicToggleSettingSpecifier("headless", (Object)DEFAULT_HEADLESS));
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("timeout", String.valueOf(10L)));
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("retries", String.valueOf(DEFAULT_RETRIES)));
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("retryDelay", String.valueOf(60L)));
        results.add((SettingSpecifier)new BasicToggleSettingSpecifier("retryReconnect", (Object)DEFAULT_RETRY_RECONNECT));
        return results;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    public void setTimeoutUnit(TimeUnit unit) {
        this.timeoutUnit = unit;
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public void setHeadless(boolean headless) {
        this.headless = headless;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }

    public TimeUnit getRetryDelayUnit() {
        return this.retryDelayUnit;
    }

    public void setRetryDelayUnit(TimeUnit retryDelayUnit) {
        this.retryDelayUnit = retryDelayUnit;
    }

    public boolean isRetryReconnect() {
        return this.retryReconnect;
    }

    public void setRetryReconnect(boolean retryReconnect) {
        this.retryReconnect = retryReconnect;
    }
}

