/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.io.modbus.support;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.BitSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import net.solarnetwork.node.io.modbus.ModbusConnection;
import net.solarnetwork.node.io.modbus.ModbusReadFunction;
import net.solarnetwork.node.io.modbus.ModbusWriteFunction;
import net.solarnetwork.node.service.LockTimeoutException;
import org.slf4j.Logger;

public class LockingModbusConnection
implements ModbusConnection {
    private final ModbusConnection delegate;
    private final ReentrantLock lock;
    private final long timeout;
    private final TimeUnit timeoutUnit;
    private final String description;
    private final Logger log;

    public LockingModbusConnection(ModbusConnection delegate, ReentrantLock lock, long timeout, TimeUnit timeoutUnit, String description, Logger log) {
        if (delegate == null) {
            throw new IllegalArgumentException("The delegate argument must not be null.");
        }
        this.delegate = delegate;
        if (lock == null) {
            throw new IllegalArgumentException("The lock argument must not be null.");
        }
        this.lock = lock;
        this.timeout = timeout;
        if (timeoutUnit == null) {
            throw new IllegalArgumentException("The timeoutUnit argument must not be null.");
        }
        this.timeoutUnit = timeoutUnit;
        if (description == null) {
            throw new IllegalArgumentException("The description argument must not be null.");
        }
        this.description = description;
        if (log == null) {
            throw new IllegalArgumentException("The log argument must not be null.");
        }
        this.log = log;
    }

    private void acquireLock() throws LockTimeoutException {
        if (this.lock.isHeldByCurrentThread()) {
            this.log.debug("Lock on Modbus port {} already acquired", (Object)this.description);
            return;
        }
        this.log.debug("Acquiring lock on Modbus port {}; waiting at most {} {}", new Object[]{this.description, this.timeout, this.timeoutUnit});
        try {
            long ts = System.currentTimeMillis();
            if (this.lock.tryLock(this.timeout, this.timeoutUnit)) {
                if (this.log.isDebugEnabled()) {
                    long t = System.currentTimeMillis() - ts;
                    this.log.debug("Acquired lock on Modbus port {} in {}ms", (Object)this.description, (Object)t);
                }
                return;
            }
            if (this.log.isDebugEnabled()) {
                long t = System.currentTimeMillis() - ts;
                this.log.debug("Timeout acquiring lock on Modbus port {} after {}ms", (Object)this.description, (Object)t);
            }
        }
        catch (InterruptedException e) {
            this.log.debug("Interrupted waiting for lock on Modbus port {}", (Object)this.description);
        }
        throw new LockTimeoutException(String.format("Could not acquire lock on Modbus port %s within %d %s", this.description, this.timeout, this.timeoutUnit.toString().toLowerCase()));
    }

    private void releaseLock() {
        if (this.lock.isHeldByCurrentThread()) {
            this.log.debug("Releasing lock on Modbus port {}", (Object)this.description);
            this.lock.unlock();
        }
    }

    @Override
    public int getUnitId() {
        return this.delegate.getUnitId();
    }

    @Override
    public void open() throws IOException, LockTimeoutException {
        this.acquireLock();
        this.delegate.open();
    }

    @Override
    public void close() {
        try {
            this.delegate.close();
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public BitSet readDiscreetValues(int address, int count) throws IOException {
        return this.delegate.readDiscreetValues(address, count);
    }

    @Override
    public BitSet readDiscreetValues(int[] addresses, int count) throws IOException {
        return this.delegate.readDiscreetValues(addresses, count);
    }

    @Override
    public void writeDiscreetValues(int[] addresses, BitSet bits) throws IOException {
        this.delegate.writeDiscreetValues(addresses, bits);
    }

    @Override
    public BitSet readInputDiscreteValues(int address, int count) throws IOException {
        return this.delegate.readInputDiscreteValues(address, count);
    }

    @Override
    public short[] readWords(ModbusReadFunction function, int address, int count) throws IOException {
        return this.delegate.readWords(function, address, count);
    }

    @Override
    public int[] readWordsUnsigned(ModbusReadFunction function, int address, int count) throws IOException {
        return this.delegate.readWordsUnsigned(function, address, count);
    }

    @Override
    public void writeWords(ModbusWriteFunction function, int address, short[] values) throws IOException {
        this.delegate.writeWords(function, address, values);
    }

    @Override
    public void writeWords(ModbusWriteFunction function, int address, int[] values) throws IOException {
        this.delegate.writeWords(function, address, values);
    }

    @Override
    public byte[] readBytes(ModbusReadFunction function, int address, int count) throws IOException {
        return this.delegate.readBytes(function, address, count);
    }

    @Override
    public void writeBytes(ModbusWriteFunction function, int address, byte[] values) throws IOException {
        this.delegate.writeBytes(function, address, values);
    }

    @Override
    public String readString(ModbusReadFunction function, int address, int count, boolean trim, Charset charset) throws IOException {
        return this.delegate.readString(function, address, count, trim, charset);
    }

    @Override
    public void writeString(ModbusWriteFunction function, int address, String value, Charset charset) throws IOException {
        this.delegate.writeString(function, address, value, charset);
    }
}

