/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.io.modbus.support;

import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import net.solarnetwork.domain.DeviceInfo;
import net.solarnetwork.node.io.modbus.ModbusConnection;
import net.solarnetwork.node.io.modbus.ModbusConnectionAction;
import net.solarnetwork.node.io.modbus.ModbusData;
import net.solarnetwork.node.io.modbus.support.ModbusDeviceDatumDataSourceSupport;

public abstract class ModbusDataDatumDataSourceSupport<T extends ModbusData>
extends ModbusDeviceDatumDataSourceSupport {
    private final T sample;
    private long sampleCacheMs = 5000L;

    public ModbusDataDatumDataSourceSupport(T data) {
        this.sample = data;
    }

    protected T getCurrentSample() throws IOException {
        return this.getCurrentSample(null);
    }

    protected T getCurrentSample(ModbusConnection connection) throws IOException {
        ModbusData currSample = null;
        if (this.isCachedSampleExpired()) {
            ModbusConnectionAction action = new ModbusConnectionAction<T>(){

                @Override
                public T doWithConnection(ModbusConnection conn) throws IOException {
                    Object sample = ModbusDataDatumDataSourceSupport.this.getSample();
                    if (((ModbusData)sample).getDataTimestamp() == null) {
                        ModbusDataDatumDataSourceSupport.this.readDeviceInfoFirstTime(conn, sample);
                    }
                    ModbusDataDatumDataSourceSupport.this.refreshDeviceData(conn, sample);
                    return ModbusDataDatumDataSourceSupport.this.createSampleSnapshot(sample);
                }
            };
            currSample = connection != null ? (ModbusData)action.doWithConnection(connection) : (ModbusData)this.performAction(action);
            if (this.log.isTraceEnabled() && currSample != null) {
                this.log.trace(currSample.dataDebugString());
            }
            this.log.debug("Read {} data: {}", (Object)this.sample.getClass().getSimpleName(), (Object)currSample);
        } else {
            currSample = (ModbusData)this.createSampleSnapshot(this.getSample());
        }
        return (T)currSample;
    }

    protected void readDeviceInfoFirstTime(ModbusConnection connection, T sample) throws IOException {
        this.refreshDeviceInfo(connection, sample);
    }

    @Override
    public DeviceInfo deviceInfo() {
        ModbusData s = ((ModbusData)this.sample).copy();
        return s.deviceInfo();
    }

    protected abstract void refreshDeviceInfo(ModbusConnection var1, T var2) throws IOException;

    protected abstract void refreshDeviceData(ModbusConnection var1, T var2) throws IOException;

    protected T createSampleSnapshot(T sample) {
        return (T)((ModbusData)sample).copy();
    }

    protected boolean isCachedSampleExpired() {
        T sample = this.getSample();
        if (((ModbusData)sample).getDataTimestamp() == null) {
            return true;
        }
        long lastReadDiff = ((ModbusData)sample).getDataTimestamp().until(Instant.now(), ChronoUnit.MILLIS);
        return lastReadDiff > this.sampleCacheMs;
    }

    @Override
    protected Map<String, Object> readDeviceInfo(ModbusConnection conn) throws IOException {
        try {
            T sample = this.getCurrentSample(conn);
            return ((ModbusData)sample).getDeviceInfo();
        }
        catch (IOException e) {
            this.log.error("Communication problem reading device info from device {}: {}", (Object)this.modbusDeviceName(), (Object)e.getMessage());
            return null;
        }
    }

    public T getSample() {
        return this.sample;
    }

    public long getSampleCacheMs() {
        return this.sampleCacheMs;
    }

    public void setSampleCacheMs(long sampleCacheMs) {
        this.sampleCacheMs = sampleCacheMs;
    }
}

