/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.io.modbus.support;

import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.solarnetwork.node.io.modbus.ModbusConnection;
import net.solarnetwork.node.io.modbus.ModbusConnectionAction;
import net.solarnetwork.node.io.modbus.ModbusData;
import net.solarnetwork.node.io.modbus.support.ModbusDeviceSupport;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.support.BasicTextFieldSettingSpecifier;

public abstract class ModbusDataDeviceSupport<T extends ModbusData>
extends ModbusDeviceSupport {
    public static final long DEFAULT_SAMPLE_CACHE_MS = 5000L;
    private final T sample;
    private long sampleCacheMs = 5000L;

    public ModbusDataDeviceSupport(T data) {
        this.sample = data;
    }

    public static List<SettingSpecifier> modbusDeviceNetworkSettings(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        ArrayList<SettingSpecifier> results = new ArrayList<SettingSpecifier>(1);
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier(prefix + "sampleCacheMs", String.valueOf(5000L)));
        return results;
    }

    protected T getCurrentSample() throws IOException {
        return this.getCurrentSample(null);
    }

    protected T getCurrentSample(ModbusConnection connection) throws IOException {
        ModbusData currSample = null;
        if (this.isCachedSampleExpired()) {
            ModbusConnectionAction action = new ModbusConnectionAction<T>(){

                @Override
                public T doWithConnection(ModbusConnection conn) throws IOException {
                    Object sample = ModbusDataDeviceSupport.this.getSample();
                    if (((ModbusData)sample).getDataTimestamp() == null) {
                        ModbusDataDeviceSupport.this.readDeviceInfoFirstTime(conn, sample);
                    }
                    ModbusDataDeviceSupport.this.refreshDeviceData(conn, sample);
                    return ModbusDataDeviceSupport.this.createSampleSnapshot(sample);
                }
            };
            currSample = connection != null ? (ModbusData)action.doWithConnection(connection) : (ModbusData)this.performAction(action);
            if (this.log.isTraceEnabled() && currSample != null) {
                this.log.trace(currSample.dataDebugString());
            }
            this.log.debug("Read {} data: {}", (Object)this.sample.getClass().getSimpleName(), (Object)currSample);
        } else {
            currSample = (ModbusData)this.createSampleSnapshot(this.getSample());
        }
        return (T)currSample;
    }

    protected void readDeviceInfoFirstTime(ModbusConnection connection, T sample) throws IOException {
        this.refreshDeviceInfo(connection, sample);
    }

    protected abstract void refreshDeviceInfo(ModbusConnection var1, T var2) throws IOException;

    protected abstract void refreshDeviceData(ModbusConnection var1, T var2) throws IOException;

    protected T createSampleSnapshot(T sample) {
        return (T)((ModbusData)sample).copy();
    }

    protected boolean isCachedSampleExpired() {
        long lastReadDiff;
        Instant ts;
        T sample = this.getSample();
        Instant instant = ts = sample != null ? ((ModbusData)sample).getDataTimestamp() : null;
        if (ts == null) {
            ts = Instant.EPOCH;
        }
        return (lastReadDiff = ts.until(Instant.now(), ChronoUnit.MILLIS)) > this.sampleCacheMs;
    }

    @Override
    protected Map<String, Object> readDeviceInfo(ModbusConnection conn) {
        try {
            T sample = this.getCurrentSample(conn);
            return ((ModbusData)sample).getDeviceInfo();
        }
        catch (IOException e) {
            this.log.error("Communication problem reading device info from device {}: {}", (Object)this.modbusDeviceName(), (Object)e.getMessage());
            return null;
        }
    }

    public T getSample() {
        return this.sample;
    }

    public long getSampleCacheMs() {
        return this.sampleCacheMs;
    }

    public void setSampleCacheMs(long sampleCacheMs) {
        this.sampleCacheMs = sampleCacheMs;
    }
}

