/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.io.modbus.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.solarnetwork.domain.BasicDeviceInfo;
import net.solarnetwork.domain.DeviceInfo;
import net.solarnetwork.node.domain.DataAccessor;
import net.solarnetwork.node.io.modbus.ModbusConnection;
import net.solarnetwork.node.io.modbus.ModbusConnectionAction;
import net.solarnetwork.node.io.modbus.ModbusNetwork;
import net.solarnetwork.node.service.support.DatumDataSourceSupport;
import net.solarnetwork.service.OptionalService;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.support.BasicTextFieldSettingSpecifier;
import net.solarnetwork.util.StringUtils;

public abstract class ModbusDeviceDatumDataSourceSupport
extends DatumDataSourceSupport {
    public static final int DEFAULT_UNIT_ID = 1;
    private Map<String, Object> deviceInfo;
    private int unitId = 1;
    private OptionalService<ModbusNetwork> modbusNetwork;

    protected List<SettingSpecifier> getModbusNetworkSettingSpecifiers() {
        return ModbusDeviceDatumDataSourceSupport.modbusNetworkSettingSpecifiers("Modbus Port", 1);
    }

    public static List<SettingSpecifier> modbusNetworkSettingSpecifiers(String uid, int unitId) {
        ArrayList<SettingSpecifier> results = new ArrayList<SettingSpecifier>(16);
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("modbusNetwork.propertyFilters['uid']", uid));
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("unitId", String.valueOf(unitId)));
        return results;
    }

    protected final ModbusNetwork modbusNetwork() {
        return this.modbusNetwork == null ? null : (ModbusNetwork)this.modbusNetwork.service();
    }

    protected abstract Map<String, Object> readDeviceInfo(ModbusConnection var1) throws IOException;

    public String getDeviceInfoMessage() {
        Map<String, ?> info = this.getDeviceInfo();
        if (info == null) {
            return null;
        }
        return StringUtils.delimitedStringFromCollection(info.values(), (String)" / ");
    }

    public Map<String, ?> getDeviceInfo() {
        Map<String, Object> info = this.deviceInfo;
        if (info == null) {
            try {
                this.deviceInfo = info = this.performAction(new ModbusConnectionAction<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> doWithConnection(ModbusConnection conn) throws IOException {
                        return ModbusDeviceDatumDataSourceSupport.this.readDeviceInfo(conn);
                    }
                });
            }
            catch (IOException e) {
                this.log.warn("Communcation problem with {}: {}", (Object)this.getUid(), (Object)e.getMessage());
            }
        }
        return info == null ? null : Collections.unmodifiableMap(info);
    }

    protected final <T> T performAction(ModbusConnectionAction<T> action) throws IOException {
        ModbusNetwork device;
        T result = null;
        ModbusNetwork modbusNetwork = device = this.modbusNetwork == null ? null : (ModbusNetwork)this.modbusNetwork.service();
        if (device != null) {
            result = device.performAction(this.unitId, action);
        }
        return result;
    }

    protected Map<String, Object> getDeviceInfoMap() {
        return this.deviceInfo;
    }

    protected void setDeviceInfoMap(Map<String, Object> deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public DeviceInfo deviceInfo() {
        Map<String, ?> info = this.getDeviceInfo();
        BasicDeviceInfo.Builder b = DataAccessor.deviceInfoBuilderForInfo(info);
        return b.isEmpty() ? null : b.build();
    }

    public String modbusDeviceName() {
        return this.getUnitId() + "@" + this.modbusNetwork();
    }

    public OptionalService<ModbusNetwork> getModbusNetwork() {
        return this.modbusNetwork;
    }

    public void setModbusNetwork(OptionalService<ModbusNetwork> modbusDevice) {
        this.modbusNetwork = modbusDevice;
    }

    public int getUnitId() {
        return this.unitId;
    }

    public void setUnitId(int unitId) {
        this.unitId = unitId;
    }
}

