/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.io.modbus.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.solarnetwork.node.io.modbus.ModbusConnection;
import net.solarnetwork.node.io.modbus.ModbusConnectionAction;
import net.solarnetwork.node.io.modbus.ModbusNetwork;
import net.solarnetwork.node.service.support.BaseIdentifiable;
import net.solarnetwork.service.OptionalService;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.support.BasicTextFieldSettingSpecifier;
import net.solarnetwork.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModbusDeviceSupport
extends BaseIdentifiable {
    public static final int DEFAULT_UNIT_ID = 1;
    public static final String DEFAULT_NETWORK_UID = "Modbus Port";
    public static final String INFO_KEY_DEVICE_MANUFACTURE_DATE = "Manufacture Date";
    private Map<String, Object> deviceInfo;
    private int unitId = 1;
    private OptionalService.OptionalFilterableService<ModbusNetwork> modbusNetwork;
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public static List<SettingSpecifier> modbusNetworkSettings(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        ArrayList<SettingSpecifier> results = new ArrayList<SettingSpecifier>(2);
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier(prefix + "modbusNetwork.propertyFilters['uid']", DEFAULT_NETWORK_UID));
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier(prefix + "unitId", String.valueOf(1)));
        return results;
    }

    protected final ModbusNetwork modbusNetwork() {
        return this.modbusNetwork == null ? null : (ModbusNetwork)this.modbusNetwork.service();
    }

    protected abstract Map<String, Object> readDeviceInfo(ModbusConnection var1) throws IOException;

    public String getDeviceInfoMessage() {
        Map<String, ?> info = this.getDeviceInfo();
        if (info == null) {
            return null;
        }
        return StringUtils.delimitedStringFromCollection(info.values(), (String)" / ");
    }

    public Map<String, ?> getDeviceInfo() {
        Map<String, Object> info = this.deviceInfo;
        if (info == null) {
            try {
                this.deviceInfo = info = this.performAction(new ModbusConnectionAction<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> doWithConnection(ModbusConnection conn) throws IOException {
                        return ModbusDeviceSupport.this.readDeviceInfo(conn);
                    }
                });
            }
            catch (IOException e) {
                this.log.warn("Communcation problem with {}: {}", (Object)this.getUid(), (Object)e.getMessage());
            }
        }
        return info == null ? null : Collections.unmodifiableMap(info);
    }

    protected final <T> T performAction(ModbusConnectionAction<T> action) throws IOException {
        ModbusNetwork device;
        T result = null;
        ModbusNetwork modbusNetwork = device = this.modbusNetwork == null ? null : (ModbusNetwork)this.modbusNetwork.service();
        if (device != null) {
            result = device.performAction(this.unitId, action);
        }
        return result;
    }

    protected Map<String, Object> getDeviceInfoMap() {
        return this.deviceInfo;
    }

    protected void setDeviceInfoMap(Map<String, Object> deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public String modbusDeviceName() {
        return this.getUnitId() + "@" + this.modbusNetwork();
    }

    public OptionalService.OptionalFilterableService<ModbusNetwork> getModbusNetwork() {
        return this.modbusNetwork;
    }

    public void setModbusNetwork(OptionalService.OptionalFilterableService<ModbusNetwork> modbusDevice) {
        this.modbusNetwork = modbusDevice;
    }

    public int getUnitId() {
        return this.unitId;
    }

    public void setUnitId(int unitId) {
        this.unitId = unitId;
    }
}

