/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.io.modbus.support;

import java.nio.charset.Charset;
import java.util.BitSet;
import net.solarnetwork.node.io.modbus.ModbusWriteFunction;
import net.solarnetwork.node.io.modbus.support.StaticDataMapReadonlyModbusConnection;
import net.solarnetwork.util.IntShortMap;

public class StaticDataMapModbusConnection
extends StaticDataMapReadonlyModbusConnection {
    public StaticDataMapModbusConnection(IntShortMap data) {
        super(data);
    }

    @Override
    public void writeWords(ModbusWriteFunction function, int address, int[] values) {
        IntShortMap data = this.getData();
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            data.putValue(address + i, values[i]);
        }
    }

    @Override
    public void writeString(ModbusWriteFunction function, int address, String value, Charset charset) {
        if (value == null || value.isEmpty()) {
            return;
        }
        byte[] data = value.getBytes(charset);
        this.writeBytes(function, address, data);
    }

    @Override
    public void writeWords(ModbusWriteFunction function, int address, short[] values) {
        IntShortMap data = this.getData();
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            data.putValue(address + i, (int)values[i]);
        }
    }

    @Override
    public void writeDiscreetValues(int[] addresses, BitSet bits) {
        IntShortMap data = this.getData();
        for (int i = 0; i < addresses.length; ++i) {
            data.putValue(addresses[i], bits.get(i) ? (short)1 : 0);
        }
    }

    @Override
    public void writeBytes(ModbusWriteFunction function, int address, byte[] values) {
        int[] unsigned = new int[(int)Math.ceil((double)values.length / 2.0)];
        for (int i = 0; i < values.length; i += 2) {
            int v = (values[i] & 0xFF) << 8;
            if (i + 1 < values.length) {
                v |= values[i + 1] & 0xFF;
            }
            unsigned[i / 2] = v;
        }
        this.writeWords(function, address, unsigned);
    }
}

