/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.io.modbus.support;

import java.nio.charset.Charset;
import java.util.BitSet;
import net.solarnetwork.node.io.modbus.ModbusDataUtils;
import net.solarnetwork.node.io.modbus.ModbusReadFunction;
import net.solarnetwork.node.io.modbus.support.ModbusConnectionSupport;
import net.solarnetwork.util.IntShortMap;

public class StaticDataMapReadonlyModbusConnection
extends ModbusConnectionSupport {
    private final IntShortMap data;

    public StaticDataMapReadonlyModbusConnection(IntShortMap data) {
        this.data = data;
    }

    public StaticDataMapReadonlyModbusConnection(int[] data) {
        this(data, 0);
    }

    public StaticDataMapReadonlyModbusConnection(int[] data, int address) {
        this(ModbusDataUtils.shortArray(data), address);
    }

    public StaticDataMapReadonlyModbusConnection(short[] data, int address) {
        this(new IntShortMap());
        for (int i = 0; i < data.length; ++i) {
            this.data.putValue(address + i, data[i]);
        }
    }

    protected IntShortMap getData() {
        return this.data;
    }

    @Override
    public int[] readWordsUnsigned(ModbusReadFunction function, int address, int count) {
        int[] out = new int[count];
        this.data.forEachOrdered(address, address + count, (k, v) -> {
            out[k - address] = v & 0xFFFF;
        });
        return out;
    }

    @Override
    public String readString(ModbusReadFunction function, int address, int count, boolean trim, Charset charset) {
        byte[] bytes = this.readBytes(function, address, count);
        String result = null;
        if (bytes != null) {
            result = new String(bytes, charset);
            if (trim) {
                result = result.trim();
            }
        }
        return result;
    }

    @Override
    public short[] readWords(ModbusReadFunction function, int address, int count) {
        short[] out = new short[count];
        this.data.forEachOrdered(address, address + count, (k, v) -> {
            out[k - address] = v;
        });
        return out;
    }

    @Override
    public BitSet readInputDiscreteValues(int address, int count) {
        return this.readDiscreetValues(address, count);
    }

    @Override
    public BitSet readDiscreetValues(int address, int count) {
        return this.readDiscreetValues(new int[]{address}, count);
    }

    @Override
    public BitSet readDiscreetValues(int[] addresses, int count) {
        BitSet out = new BitSet();
        int w = 0;
        for (int i = 0; i < addresses.length; ++i) {
            short d = this.data.getValue(addresses[i]);
            int j = 0;
            while (j < count) {
                if ((d >> j & 1) == 1) {
                    out.set(w);
                }
                ++j;
                ++w;
            }
        }
        return out;
    }

    @Override
    public byte[] readBytes(ModbusReadFunction function, int address, int count) {
        byte[] result = new byte[count * 2];
        for (int i = 0; i < count; ++i) {
            short d = this.data.getValue(address + i);
            result[i * 2] = (byte)(d >> 8 & 0xFF);
            result[i * 2 + 1] = (byte)(d & 0xFF);
        }
        return result;
    }
}

