/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.backup;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.regex.Pattern;
import net.solarnetwork.node.backup.BackupResource;
import net.solarnetwork.node.backup.BackupResourceInfo;
import net.solarnetwork.node.backup.BackupResourceProvider;
import net.solarnetwork.node.backup.BackupResourceProviderInfo;
import net.solarnetwork.node.backup.ResourceBackupResource;
import net.solarnetwork.node.backup.SimpleBackupResourceInfo;
import net.solarnetwork.node.backup.SimpleBackupResourceProviderInfo;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class FileBackupResourceProvider
implements BackupResourceProvider {
    private String rootPath = System.getProperty("sn.home", "");
    private String[] resourceDirectories = new String[]{"app/main"};
    private String fileNamePattern = "\\.jar$";
    private MessageSource messageSource;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public String getKey() {
        return FileBackupResourceProvider.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<BackupResource> getBackupResources() {
        if (this.resourceDirectories == null || this.resourceDirectories.length < 1) {
            return Collections.emptyList();
        }
        final Pattern pat = this.fileNamePattern == null ? null : Pattern.compile(this.fileNamePattern, 2);
        ArrayList<BackupResource> fileList = new ArrayList<BackupResource>(20);
        for (String path : this.resourceDirectories) {
            File rootDir;
            File file = rootDir = this.rootPath != null && this.rootPath.length() > 0 ? new File(this.rootPath, path) : new File(path);
            if (!rootDir.isDirectory()) {
                this.log.info("Skipping path {} because does not exist or is not a directory", (Object)rootDir.getAbsolutePath());
                continue;
            }
            File[] files = rootDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return pat.matcher(name).find();
                }
            });
            if (files == null || files.length < 1) continue;
            for (File f : files) {
                String backupPath = path + '/' + f.getName();
                String digest = null;
                InputStream in = null;
                try {
                    in = new BufferedInputStream(new FileInputStream(f));
                    digest = DigestUtils.sha256Hex((InputStream)in);
                }
                catch (IOException e) {
                    this.log.warn("Error calculating SHA-256 digest of {}: {}", (Object)f, (Object)e.getMessage());
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                fileList.add(new ResourceBackupResource((Resource)new FileSystemResource(f), backupPath, this.getKey(), digest));
            }
        }
        return fileList;
    }

    @Override
    public boolean restoreBackupResource(BackupResource resource) {
        if (this.resourceDirectories != null && this.resourceDirectories.length > 0) {
            for (String path : this.resourceDirectories) {
                File rootDir = new File(this.rootPath, path);
                File backupFile = new File(resource.getBackupPath());
                if (!backupFile.getAbsolutePath().startsWith(rootDir.getAbsolutePath())) continue;
                if (!backupFile.getParentFile().isDirectory() && !backupFile.getParentFile().mkdirs()) {
                    this.log.warn("Unable to create directory {} to restore file {} into", (Object)backupFile.getParent(), (Object)resource.getBackupPath());
                }
                try {
                    File tempFile = new File(backupFile.getParentFile(), "." + backupFile.getName());
                    this.log.debug("Installing resource {} => {}", (Object)resource.getBackupPath(), (Object)tempFile);
                    FileCopyUtils.copy((InputStream)resource.getInputStream(), (OutputStream)new FileOutputStream(tempFile));
                    tempFile.setLastModified(resource.getModificationDate());
                    this.moveTemporaryResourceFile(tempFile, backupFile);
                }
                catch (IOException e) {
                    this.log.error("Unable to restore backup resource {} to {}: {}", new Object[]{resource.getBackupPath(), rootDir.getPath(), e.getMessage()});
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveTemporaryResourceFile(File tempFile, File outputFile) throws IOException {
        if (outputFile.exists()) {
            FileInputStream outputFileInputStream = null;
            InputStream tmpOutputFileInputStream = null;
            try {
                outputFileInputStream = new FileInputStream(outputFile);
                tmpOutputFileInputStream = new FileInputStream(tempFile);
                String outputFileHash = DigestUtils.sha256Hex((InputStream)outputFileInputStream);
                String tmpOutputFileHash = DigestUtils.sha256Hex((InputStream)tmpOutputFileInputStream);
                if (tmpOutputFileHash.equals(outputFileHash)) {
                    tempFile.delete();
                }
                this.log.debug("{} content updated", (Object)outputFile);
                outputFile.delete();
                tempFile.renameTo(outputFile);
            }
            finally {
                if (outputFileInputStream != null) {
                    try {
                        ((InputStream)outputFileInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                if (tmpOutputFileInputStream != null) {
                    try {
                        tmpOutputFileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            tempFile.renameTo(outputFile);
        }
    }

    @Override
    public BackupResourceProviderInfo providerInfo(Locale locale) {
        String name = "File Backup Provider";
        String desc = "Backs up system plugins.";
        MessageSource ms = this.messageSource;
        if (ms != null) {
            name = ms.getMessage("title", null, name, locale);
            desc = ms.getMessage("desc", null, desc, locale);
        }
        return new SimpleBackupResourceProviderInfo(this.getKey(), name, desc);
    }

    @Override
    public BackupResourceInfo resourceInfo(BackupResource resource, Locale locale) {
        return new SimpleBackupResourceInfo(resource.getProviderKey(), resource.getBackupPath(), null);
    }

    public void setResourceDirs(String list) {
        this.setResourceDirectories(StringUtils.commaDelimitedListToStringArray((String)list));
    }

    public String getResourceDirs() {
        return StringUtils.arrayToCommaDelimitedString((Object[])this.getResourceDirectories());
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public String[] getResourceDirectories() {
        return this.resourceDirectories;
    }

    public void setResourceDirectories(String[] bundlePaths) {
        this.resourceDirectories = bundlePaths;
    }

    public String getFileNamePattern() {
        return this.fileNamePattern;
    }

    public void setFileNamePattern(String fileNamePattern) {
        this.fileNamePattern = fileNamePattern;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }
}

