/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.backup;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.solarnetwork.node.backup.Backup;
import net.solarnetwork.node.backup.BackupResource;
import net.solarnetwork.node.backup.BackupResourceIterable;
import net.solarnetwork.node.backup.BackupServiceInfo;
import net.solarnetwork.node.backup.BackupServiceSupport;
import net.solarnetwork.node.backup.BackupStatus;
import net.solarnetwork.node.backup.CollectionBackupResourceIterable;
import net.solarnetwork.node.backup.SimpleBackup;
import net.solarnetwork.node.backup.SimpleBackupServiceInfo;
import net.solarnetwork.node.backup.ZipEntryBackupResource;
import net.solarnetwork.node.service.IdentityService;
import net.solarnetwork.service.OptionalService;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.SettingSpecifierProvider;
import net.solarnetwork.settings.support.BasicSliderSettingSpecifier;
import net.solarnetwork.settings.support.BasicTextFieldSettingSpecifier;
import net.solarnetwork.settings.support.BasicTitleSettingSpecifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.util.FileCopyUtils;

public class FileSystemBackupService
extends BackupServiceSupport
implements SettingSpecifierProvider {
    public static final String KEY = FileSystemBackupService.class.getName();
    public static final String ARCHIVE_KEY_NAME_FORMAT = "node-%2$d-backup-%1$s.zip";
    private static final String ARCHIVE_NAME_FORMAT = "node-%2$d-backup-%1$tY%1$tm%1$tdT%1$tH%1$tM%1$tS.zip";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private MessageSource messageSource;
    private File backupDir = this.defaultBackuprDir();
    private OptionalService<IdentityService> identityService;
    private int additionalBackupCount = 1;
    private BackupStatus status = BackupStatus.Configured;

    public String getSettingUid() {
        return this.getClass().getName();
    }

    public String getDisplayName() {
        return "File System Backup Service";
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public List<SettingSpecifier> getSettingSpecifiers() {
        ArrayList<SettingSpecifier> results = new ArrayList<SettingSpecifier>(4);
        FileSystemBackupService defaults = new FileSystemBackupService();
        results.add((SettingSpecifier)new BasicTitleSettingSpecifier("status", this.getStatus().toString(), true));
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("backupDir", defaults.getBackupDir().getAbsolutePath()));
        results.add((SettingSpecifier)new BasicSliderSettingSpecifier("additionalBackupCount", Double.valueOf(defaults.getAdditionalBackupCount()), Double.valueOf(0.0), Double.valueOf(10.0), Double.valueOf(1.0)));
        return results;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public BackupServiceInfo getInfo() {
        return new SimpleBackupServiceInfo(null, this.getStatus());
    }

    private String getArchiveKey(String archiveName) {
        Matcher m = NODE_AND_DATE_BACKUP_KEY_PATTERN.matcher(archiveName);
        if (m.find()) {
            return m.group(2);
        }
        return archiveName;
    }

    @Override
    public Backup backupForKey(String key) {
        File archiveFile = this.getArchiveFileForBackup(key);
        if (!archiveFile.canRead()) {
            return null;
        }
        return this.createBackupForFile(archiveFile, new SimpleDateFormat("yyyyMMdd'T'HHmmss"));
    }

    @Override
    public Backup performBackup(Iterable<BackupResource> resources) {
        GregorianCalendar now = new GregorianCalendar();
        now.set(14, 0);
        return this.performBackupInternal(resources, now, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Backup performBackupInternal(Iterable<BackupResource> resources, Calendar now, Map<String, String> props) {
        if (resources == null) {
            return null;
        }
        Iterator<BackupResource> itr = resources.iterator();
        if (!itr.hasNext()) {
            this.log.debug("No resources provided, nothing to backup");
            return null;
        }
        BackupStatus status = this.setStatusIf(BackupStatus.RunningBackup, BackupStatus.Configured);
        if (status != BackupStatus.RunningBackup && (status = this.setStatusIf(BackupStatus.RunningBackup, BackupStatus.Error)) != BackupStatus.RunningBackup) {
            return null;
        }
        if (!this.backupDir.exists()) {
            this.backupDir.mkdirs();
        }
        Long nodeId = this.nodeIdForArchiveFileName(props);
        String archiveName = String.format(ARCHIVE_NAME_FORMAT, now, nodeId);
        File archiveFile = new File(this.backupDir, archiveName);
        String archiveKey = this.getArchiveKey(archiveName);
        this.log.info("Starting backup to archive {}", (Object)archiveName);
        this.log.trace("Backup archive: {}", (Object)archiveFile.getAbsolutePath());
        SimpleBackup backup = null;
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(archiveFile)));
            while (itr.hasNext()) {
                BackupResource r = itr.next();
                this.log.debug("Backup up resource {} to archive {}", (Object)r.getBackupPath(), (Object)archiveName);
                zos.putNextEntry(new ZipEntry(r.getBackupPath()));
                FileCopyUtils.copy((InputStream)r.getInputStream(), (OutputStream)new FilterOutputStream(zos){

                    @Override
                    public void close() throws IOException {
                    }
                });
            }
            zos.flush();
            zos.finish();
            this.log.info("Backup complete to archive {}", (Object)archiveName);
            backup = new SimpleBackup(nodeId, now.getTime(), archiveKey, archiveFile.length(), true);
            File[] backupFiles = this.getAvailableBackupFiles();
            if (backupFiles != null && backupFiles.length > this.additionalBackupCount + 1) {
                for (int i = this.additionalBackupCount + 1; i < backupFiles.length; ++i) {
                    this.log.info("Deleting old backup archive {}", (Object)backupFiles[i].getName());
                    if (backupFiles[i].delete()) continue;
                    this.log.warn("Unable to delete backup archive {}", (Object)backupFiles[i].getAbsolutePath());
                }
            }
        }
        catch (IOException e) {
            this.log.error("IO error creating backup: {}", (Object)e.getMessage());
            this.setStatus(BackupStatus.Error);
        }
        catch (RuntimeException e) {
            this.log.error("Error creating backup: {}", (Object)e.getMessage());
            this.setStatus(BackupStatus.Error);
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException e) {}
            }
            if ((status = this.setStatusIf(BackupStatus.Configured, BackupStatus.RunningBackup)) != BackupStatus.Configured && archiveFile.exists()) {
                archiveFile.delete();
            }
        }
        return backup;
    }

    private final Long nodeIdForArchiveFileName(Map<String, String> props) {
        Long nodeId = this.backupNodeIdFromProps(null, props);
        if (nodeId == 0L) {
            nodeId = this.nodeIdForArchiveFileName();
        }
        return nodeId;
    }

    private final Long nodeIdForArchiveFileName() {
        IdentityService service = this.identityService != null ? (IdentityService)this.identityService.service() : null;
        Long nodeId = service != null ? service.getNodeId() : null;
        return nodeId != null ? nodeId : 0L;
    }

    private File getArchiveFileForBackup(final String backupKey) {
        Long nodeId = this.nodeIdForArchiveFileName();
        if (nodeId.intValue() == 0) {
            File[] matches = this.backupDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.contains(backupKey);
                }
            });
            if (matches != null && matches.length > 0) {
                return matches[0];
            }
            return null;
        }
        return new File(this.backupDir, String.format(ARCHIVE_KEY_NAME_FORMAT, backupKey, nodeId));
    }

    @Override
    public BackupResourceIterable getBackupResources(Backup backup) {
        File archiveFile = this.getArchiveFileForBackup(backup.getKey());
        if (!archiveFile.isFile() || !archiveFile.canRead()) {
            this.log.warn("No backup archive exists for key [{}]", (Object)backup.getKey());
            List<BackupResource> col = Collections.emptyList();
            return new CollectionBackupResourceIterable(col);
        }
        try {
            final ZipFile zf = new ZipFile(archiveFile);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            ArrayList<ZipEntryBackupResource> result = new ArrayList<ZipEntryBackupResource>(20);
            while (entries.hasMoreElements()) {
                result.add(new ZipEntryBackupResource(zf, entries.nextElement()));
            }
            return new CollectionBackupResourceIterable(result){

                @Override
                public void close() throws IOException {
                    zf.close();
                }
            };
        }
        catch (IOException e) {
            this.log.error("Error extracting backup archive entries: {}", (Object)e.getMessage());
            List<BackupResource> col = Collections.emptyList();
            return new CollectionBackupResourceIterable(col);
        }
    }

    @Override
    public Backup importBackup(Date date, BackupResourceIterable resources, Map<String, String> props) {
        Date backupDate = this.backupDateFromProps(date, props);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(backupDate);
        cal.set(14, 0);
        return this.performBackupInternal(resources, cal, props);
    }

    public void removeAllBackups() {
        File[] archives = this.backupDir.listFiles(new ArchiveFilter(this.nodeIdForArchiveFileName()));
        if (archives == null) {
            return;
        }
        for (File archive : archives) {
            this.log.debug("Deleting backup archive {}", (Object)archive.getName());
            if (archive.delete()) continue;
            this.log.warn("Unable to delete archive file {}", (Object)archive.getAbsolutePath());
        }
    }

    private File[] getAvailableBackupFiles() {
        File[] archives = this.backupDir.listFiles(new ArchiveFilter(this.nodeIdForArchiveFileName()));
        if (archives != null) {
            Arrays.sort(archives, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o2.getName().compareTo(o1.getName());
                }
            });
        }
        return archives;
    }

    private SimpleBackup createBackupForFile(File f, SimpleDateFormat sdf) {
        Matcher m = NODE_AND_DATE_BACKUP_KEY_PATTERN.matcher(f.getName());
        if (m.find()) {
            try {
                Date d = sdf.parse(m.group(2));
                Long nodeId = 0L;
                try {
                    nodeId = Long.valueOf(m.group(1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return new SimpleBackup(nodeId, d, m.group(2), f.length(), true);
            }
            catch (ParseException e) {
                this.log.error("Error parsing date from archive " + f.getName() + ": " + e.getMessage());
            }
        }
        return null;
    }

    @Override
    public Collection<Backup> getAvailableBackups() {
        File[] archives = this.getAvailableBackupFiles();
        if (archives == null) {
            return Collections.emptyList();
        }
        ArrayList<Backup> result = new ArrayList<Backup>(archives.length);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
        for (File f : archives) {
            SimpleBackup b = this.createBackupForFile(f, sdf);
            if (b == null) continue;
            result.add(b);
        }
        return result;
    }

    @Override
    public SettingSpecifierProvider getSettingSpecifierProvider() {
        return this;
    }

    @Override
    public SettingSpecifierProvider getSettingSpecifierProviderForRestore() {
        return new SettingSpecifierProvider(){

            public String getSettingUid() {
                return FileSystemBackupService.this.getSettingUid();
            }

            public List<SettingSpecifier> getSettingSpecifiers() {
                ArrayList<SettingSpecifier> results = new ArrayList<SettingSpecifier>(4);
                results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("backupDir", FileSystemBackupService.this.defaultBackuprDir().getAbsolutePath()));
                return results;
            }

            public MessageSource getMessageSource() {
                return FileSystemBackupService.this.getMessageSource();
            }

            public String getDisplayName() {
                return FileSystemBackupService.this.getDisplayName();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BackupStatus getStatus() {
        BackupStatus backupStatus = this.status;
        synchronized (backupStatus) {
            if (this.backupDir == null) {
                return BackupStatus.Unconfigured;
            }
            if (!this.backupDir.exists() && !this.backupDir.mkdirs()) {
                this.log.warn("Could not create backup dir {}", (Object)this.backupDir.getAbsolutePath());
                return BackupStatus.Unconfigured;
            }
            if (!this.backupDir.isDirectory()) {
                this.log.error("Configured backup location is not a directory: {}", (Object)this.backupDir.getAbsolutePath());
                return BackupStatus.Unconfigured;
            }
            return this.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStatus(BackupStatus newStatus) {
        BackupStatus backupStatus = this.status;
        synchronized (backupStatus) {
            this.status = newStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BackupStatus setStatusIf(BackupStatus newStatus, BackupStatus ifStatus) {
        BackupStatus backupStatus = this.status;
        synchronized (backupStatus) {
            if (this.status == ifStatus) {
                this.status = newStatus;
            }
            return this.status;
        }
    }

    public File getBackupDir() {
        return this.backupDir;
    }

    public void setBackupDir(File backupDir) {
        this.backupDir = backupDir;
    }

    public int getAdditionalBackupCount() {
        return this.additionalBackupCount;
    }

    public void setAdditionalBackupCount(int additionalBackupCount) {
        this.additionalBackupCount = additionalBackupCount;
    }

    public OptionalService<IdentityService> getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(OptionalService<IdentityService> identityService) {
        this.identityService = identityService;
    }

    private static class ArchiveFilter
    implements FilenameFilter {
        final Long nodeId;

        private ArchiveFilter(Long nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public boolean accept(File dir, String name) {
            Matcher m = BackupServiceSupport.NODE_AND_DATE_BACKUP_KEY_PATTERN.matcher(name);
            return m.find() && (this.nodeId == null || this.nodeId.equals(Long.valueOf(m.group(1)))) && name.endsWith(".zip");
        }
    }
}

