/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.backup;

import java.io.IOException;
import java.io.InputStream;
import net.solarnetwork.node.backup.BackupResource;
import net.solarnetwork.node.backup.FileBackupResourceProvider;
import org.springframework.core.io.Resource;

public class ResourceBackupResource
implements BackupResource {
    private final Resource resource;
    private final String backupPath;
    private final String providerKey;
    private final String sha256Digest;

    public ResourceBackupResource(Resource resource, String backupPath) {
        this(resource, backupPath, FileBackupResourceProvider.class.getName(), null);
    }

    public ResourceBackupResource(Resource resource, String backupPath, String providerKey) {
        this(resource, backupPath, providerKey, null);
    }

    public ResourceBackupResource(Resource resource, String backupPath, String providerKey, String sha256Digest) {
        this.resource = resource;
        this.backupPath = backupPath;
        this.providerKey = providerKey;
        this.sha256Digest = sha256Digest;
    }

    @Override
    public String getProviderKey() {
        return this.providerKey;
    }

    @Override
    public String getBackupPath() {
        return this.backupPath;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.resource.getInputStream();
    }

    @Override
    public long getModificationDate() {
        try {
            return this.resource.getFile().lastModified();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    @Override
    public String getSha256Digest() {
        return this.sha256Digest;
    }
}

