/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.backup;

import java.util.Date;
import net.solarnetwork.node.backup.Backup;
import net.solarnetwork.node.backup.BackupIdentity;

public class SimpleBackup
implements Backup {
    private final Date date;
    private final String key;
    private final Long size;
    private final boolean complete;
    private final Long nodeId;
    private final String qualifier;

    public SimpleBackup(Date date, String key, Long size, boolean complete) {
        this(null, date, key, size, complete);
    }

    public SimpleBackup(Long nodeId, Date date, String key, Long size, boolean complete) {
        this(nodeId, date, null, key, size, complete);
    }

    public SimpleBackup(Long nodeId, Date date, String qualifier, String key, Long size, boolean complete) {
        this.nodeId = nodeId;
        this.date = date;
        this.qualifier = qualifier;
        this.key = key;
        this.size = size;
        this.complete = complete;
    }

    public SimpleBackup(BackupIdentity ident, Long size, boolean complete) {
        this(ident.getNodeId(), ident.getDate(), ident.getQualifier(), ident.getKey(), size, complete);
    }

    @Override
    public Long getNodeId() {
        return this.nodeId;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public String getQualifier() {
        return this.qualifier;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Long getSize() {
        return this.size;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }
}

