/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.backup;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.solarnetwork.node.backup.BackupResource;
import net.solarnetwork.node.backup.BackupResourceIterable;
import net.solarnetwork.node.backup.ZipStreamBackupResource;
import net.solarnetwork.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZipStreamBackupResourceIterable
implements BackupResourceIterable {
    private final ZipInputStream zin;
    private final Set<String> providerKeySet;
    private final String backupKey;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public ZipStreamBackupResourceIterable(ZipInputStream zin, Map<String, String> props) {
        this.zin = zin;
        this.providerKeySet = props == null ? null : StringUtils.commaDelimitedStringToSet((String)props.get("ResourceProviderFilter"));
        this.backupKey = props == null ? null : props.get("BackupKey");
    }

    @Override
    public void close() throws IOException {
        this.zin.close();
    }

    @Override
    public Iterator<BackupResource> iterator() {
        return new Iterator<BackupResource>(){
            private ZipEntry currEntry = null;
            private String currProviderKey = null;

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                if (this.currEntry == null) {
                    this.currProviderKey = null;
                    try {
                        ZipEntry entry;
                        while ((entry = ZipStreamBackupResourceIterable.this.zin.getNextEntry()) != null) {
                            String path = entry.getName();
                            ZipStreamBackupResourceIterable.this.log.debug("Inspecting backup resource {}", (Object)path);
                            int providerIndex = path.indexOf(47);
                            if (providerIndex == -1) continue;
                            String providerKey = path.substring(0, providerIndex);
                            if (ZipStreamBackupResourceIterable.this.providerKeySet != null && !ZipStreamBackupResourceIterable.this.providerKeySet.isEmpty() && !ZipStreamBackupResourceIterable.this.providerKeySet.contains(providerKey)) {
                                ZipStreamBackupResourceIterable.this.log.debug("Skipping backup {} resource {} (provider filtered)", (Object)ZipStreamBackupResourceIterable.this.backupKey, (Object)path);
                                continue;
                            }
                            this.currProviderKey = providerKey;
                            this.currEntry = entry;
                            break;
                        }
                    }
                    catch (IOException e) {
                        ZipStreamBackupResourceIterable.this.log.debug("IOException importing backup archive: {}", (Object)e.getMessage());
                    }
                }
                return this.currEntry != null;
            }

            @Override
            public BackupResource next() {
                if (!this.hasNext()) {
                    return null;
                }
                ZipEntry entry = this.currEntry;
                ZipStreamBackupResource result = null;
                if (entry != null) {
                    result = new ZipStreamBackupResource(ZipStreamBackupResourceIterable.this.zin, entry, this.currProviderKey, entry.getName());
                    this.currEntry = null;
                    this.currProviderKey = null;
                }
                return result;
            }
        };
    }
}

