/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.job;

import java.util.Collections;
import java.util.List;
import net.solarnetwork.node.dao.DatumDao;
import net.solarnetwork.node.job.JobService;
import net.solarnetwork.node.service.support.BaseIdentifiable;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.util.ObjectUtils;

public class DatumDaoCleanerJob
extends BaseIdentifiable
implements JobService {
    public static final int DEFAULT_HOURS = 4;
    private final DatumDao datumDao;
    private int hours = 4;

    public DatumDaoCleanerJob(DatumDao datumDao) {
        this.datumDao = (DatumDao)ObjectUtils.requireNonNullArgument((Object)datumDao, (String)"datumDao");
    }

    public String getSettingUid() {
        String uid = this.getUid();
        return uid != null && !uid.isEmpty() ? uid : "net.solarnetwork.node.job.DatumDaoCleanerJob";
    }

    public List<SettingSpecifier> getSettingSpecifiers() {
        return Collections.emptyList();
    }

    @Override
    public void executeJobService() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Deleting datum data older than [{}] hours", (Object)this.hours);
        }
        int result = this.datumDao.deleteUploadedDataOlderThan(this.hours);
        if (this.log.isInfoEnabled() && result > 0) {
            this.log.info("Deleted {} datum older than {} hours", (Object)result, (Object)this.hours);
        }
    }

    public int getHours() {
        return this.hours;
    }

    public void setHours(int hours) {
        this.hours = hours;
    }
}

