/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.job;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import net.solarnetwork.codec.JsonUtils;
import net.solarnetwork.domain.DeviceInfo;
import net.solarnetwork.domain.datum.GeneralDatumMetadata;
import net.solarnetwork.node.domain.datum.NodeDatum;
import net.solarnetwork.node.job.JobService;
import net.solarnetwork.node.service.DatumDataSource;
import net.solarnetwork.node.service.DatumMetadataService;
import net.solarnetwork.node.service.DatumQueue;
import net.solarnetwork.node.service.DeviceInfoProvider;
import net.solarnetwork.node.service.LockTimeoutException;
import net.solarnetwork.node.service.MultiDatumDataSource;
import net.solarnetwork.node.service.support.BaseIdentifiable;
import net.solarnetwork.service.Identifiable;
import net.solarnetwork.service.OptionalService;
import net.solarnetwork.service.ServiceLifecycleObserver;
import net.solarnetwork.settings.MappableSpecifier;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.SettingSpecifierProvider;
import net.solarnetwork.settings.SettingsChangeObserver;
import org.springframework.context.MessageSource;

public class DatumDataSourcePollManagedJob
extends BaseIdentifiable
implements JobService,
SettingsChangeObserver,
ServiceLifecycleObserver {
    private static final Set<String> PUBLISHED_DEVICE_INFO_SOURCE_IDS = new ConcurrentSkipListSet<String>();
    private DatumDataSource datumDataSource = null;
    private MultiDatumDataSource multiDatumDataSource = null;
    private OptionalService<DatumQueue> datumQueue = null;
    private OptionalService<DatumMetadataService> datumMetadataService = null;

    @Override
    public void executeJobService() throws Exception {
        try {
            if (this.multiDatumDataSource != null) {
                this.executeForMultiDatumDataSource();
            } else {
                this.executeForDatumDataSource();
            }
        }
        catch (Throwable e) {
            this.logThrowable(e);
        }
    }

    public String toString() {
        Identifiable delegate = this.multiDatumDataSource != null ? this.multiDatumDataSource : this.datumDataSource;
        return String.format("DatumDataSourcePollManagedJob{%s}", delegate);
    }

    public void serviceDidStartup() {
        ServiceLifecycleObserver delegate = this.serviceLifecycleObserver();
        if (delegate != null) {
            delegate.serviceDidStartup();
        }
    }

    public void serviceDidShutdown() {
        ServiceLifecycleObserver delegate = this.serviceLifecycleObserver();
        if (delegate != null) {
            delegate.serviceDidShutdown();
        }
    }

    public void configurationChanged(Map<String, Object> properties) {
        if (this.datumDataSource instanceof SettingsChangeObserver) {
            ((SettingsChangeObserver)this.datumDataSource).configurationChanged(properties);
        }
        if (this.multiDatumDataSource instanceof SettingsChangeObserver) {
            ((SettingsChangeObserver)this.multiDatumDataSource).configurationChanged(properties);
        }
    }

    private void executeForDatumDataSource() {
        NodeDatum datum;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Collecting [{}] from [{}]", (Object)this.datumDataSource.getDatumType().getSimpleName(), (Object)this.datumDataSource);
        }
        if ((datum = this.datumDataSource.readCurrentDatum()) != null) {
            this.persistDatum(this.datumDataSource, Collections.singleton(datum));
        } else {
            this.log.debug("No data returned from [{}]", (Object)this.datumDataSource);
        }
    }

    private void executeForMultiDatumDataSource() {
        Collection<NodeDatum> datum;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Collecting [{}] from [{}]", (Object)this.multiDatumDataSource.getMultiDatumType().getSimpleName(), (Object)this.multiDatumDataSource);
        }
        if ((datum = this.multiDatumDataSource.readMultipleDatum()) != null && datum.size() > 0) {
            this.persistDatum(this.multiDatumDataSource, datum);
        } else {
            this.log.debug("No data returned from [{}]", (Object)this.multiDatumDataSource);
        }
    }

    private void logThrowable(Throwable e) {
        Throwable ioEx = null;
        Throwable t = e;
        while (true) {
            if (t instanceof IOException || t instanceof LockTimeoutException) {
                ioEx = t;
                break;
            }
            if (t.getCause() == null) break;
            t = t.getCause();
        }
        if (ioEx != null) {
            this.log.warn("Communication problem collecting data from {}: {}", (Object)(this.multiDatumDataSource != null ? this.multiDatumDataSource : this.datumDataSource), (Object)ioEx.toString());
        } else {
            this.log.error("Error collecting data from {}: {}", new Object[]{this.multiDatumDataSource != null ? this.multiDatumDataSource : this.datumDataSource, t.toString(), t});
        }
    }

    private void persistDatum(DeviceInfoProvider infoProvider, Collection<NodeDatum> datumList) {
        DatumQueue queue;
        if (datumList == null || datumList.size() < 1) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Got Datum to persist: {}", (Object)(datumList.size() == 1 ? datumList.iterator().next().toString() : datumList.toString()));
        }
        if ((queue = (DatumQueue)OptionalService.service(this.datumQueue)) == null) {
            this.log.info("No DatumQueue available to offer {}, not saving", datumList);
            return;
        }
        for (NodeDatum datum : datumList) {
            queue.offer(datum, true);
            this.log.debug("Offered datum {} to queue", (Object)datum);
        }
        if (infoProvider.canPublishDeviceInfo()) {
            this.publishDeviceInfoMetadata(infoProvider);
        }
    }

    private void publishDeviceInfoMetadata(DeviceInfoProvider infoProvider) {
        String metaSourceId = infoProvider.deviceInfoSourceId();
        if (metaSourceId == null) {
            return;
        }
        DatumMetadataService metadataService = (DatumMetadataService)OptionalService.service(this.datumMetadataService);
        if (metadataService == null) {
            return;
        }
        if (PUBLISHED_DEVICE_INFO_SOURCE_IDS.contains(metaSourceId)) {
            return;
        }
        DeviceInfo info = infoProvider.deviceInfo();
        Map m = JsonUtils.getStringMapFromObject((Object)info);
        if (m != null && !m.isEmpty()) {
            GeneralDatumMetadata meta = new GeneralDatumMetadata(null, Collections.singletonMap("deviceInfo", m));
            metadataService.addSourceMetadata(metaSourceId, meta);
        }
        PUBLISHED_DEVICE_INFO_SOURCE_IDS.add(metaSourceId);
    }

    private SettingSpecifierProvider settingSpecifierProvider() {
        if (this.multiDatumDataSource instanceof SettingSpecifierProvider) {
            return (SettingSpecifierProvider)this.multiDatumDataSource;
        }
        if (this.datumDataSource instanceof SettingSpecifierProvider) {
            return (SettingSpecifierProvider)this.datumDataSource;
        }
        return null;
    }

    private ServiceLifecycleObserver serviceLifecycleObserver() {
        if (this.multiDatumDataSource instanceof ServiceLifecycleObserver) {
            return (ServiceLifecycleObserver)this.multiDatumDataSource;
        }
        if (this.datumDataSource instanceof ServiceLifecycleObserver) {
            return (ServiceLifecycleObserver)this.datumDataSource;
        }
        return null;
    }

    public String getSettingUid() {
        SettingSpecifierProvider delegate = this.settingSpecifierProvider();
        if (delegate != null) {
            return delegate.getSettingUid();
        }
        return this.getDatumDataSource().getClass().getName();
    }

    public String getDisplayName() {
        SettingSpecifierProvider delegate = this.settingSpecifierProvider();
        if (delegate != null) {
            return delegate.getDisplayName();
        }
        return null;
    }

    public MessageSource getMessageSource() {
        SettingSpecifierProvider delegate = this.settingSpecifierProvider();
        if (delegate != null) {
            return delegate.getMessageSource();
        }
        return super.getMessageSource();
    }

    public List<SettingSpecifier> getSettingSpecifiers() {
        SettingSpecifierProvider delegate = this.settingSpecifierProvider();
        if (delegate == null) {
            return Collections.emptyList();
        }
        ArrayList<SettingSpecifier> result = new ArrayList<SettingSpecifier>();
        String prefix = this.multiDatumDataSource != null ? "multiDatumDataSource." : "datumDataSource.";
        for (SettingSpecifier spec : delegate.getSettingSpecifiers()) {
            if (spec instanceof MappableSpecifier) {
                MappableSpecifier mappable = (MappableSpecifier)spec;
                result.add(mappable.mappedTo(prefix));
                continue;
            }
            result.add(spec);
        }
        return result;
    }

    public DatumDataSource getDatumDataSource() {
        return this.datumDataSource;
    }

    public void setDatumDataSource(DatumDataSource datumDataSource) {
        this.datumDataSource = datumDataSource;
    }

    public MultiDatumDataSource getMultiDatumDataSource() {
        return this.multiDatumDataSource;
    }

    public void setMultiDatumDataSource(MultiDatumDataSource multiDatumDataSource) {
        this.multiDatumDataSource = multiDatumDataSource;
    }

    public OptionalService<DatumQueue> getDatumQueue() {
        return this.datumQueue;
    }

    public void setDatumQueue(OptionalService<DatumQueue> datumQueue) {
        this.datumQueue = datumQueue;
    }

    public OptionalService<DatumMetadataService> getDatumMetadataService() {
        return this.datumMetadataService;
    }

    public void setDatumMetadataService(OptionalService<DatumMetadataService> datumMetadataService) {
        this.datumMetadataService = datumMetadataService;
    }
}

