/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.reactor;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.solarnetwork.node.reactor.Instruction;
import net.solarnetwork.node.reactor.InstructionStatus;

public class BasicInstruction
extends net.solarnetwork.domain.BasicInstruction
implements Instruction,
Serializable {
    private static final long serialVersionUID = 3391977559465548659L;
    private final String instructorId;

    public static BasicInstruction from(net.solarnetwork.domain.Instruction instr, String instructorId) {
        if (instr == null) {
            return null;
        }
        BasicInstruction result = new BasicInstruction(instr.getId(), instr.getTopic(), instr.getInstructionDate(), instructorId, null);
        for (String paramName : instr.getParameterNames()) {
            String[] paramValues = instr.getAllParameterValues(paramName);
            if (paramValues == null) continue;
            result.putParameters(paramName, Arrays.asList(paramValues));
        }
        return result;
    }

    public BasicInstruction(String topic, Instant instructionDate, String instructorId, InstructionStatus status) {
        this(null, topic, instructionDate, instructorId, status);
    }

    public BasicInstruction(Long id, String topic, Instant instructionDate, String instructorId, InstructionStatus status) {
        super(id, topic, instructionDate, (net.solarnetwork.domain.InstructionStatus)status);
        this.instructorId = instructorId;
    }

    public BasicInstruction(Instruction other, Long id, InstructionStatus status) {
        this(id != null ? id : other.getId(), other.getTopic(), other.getInstructionDate(), other.getInstructorId(), status != null ? status : other.getStatus());
        Map otherParams = other.getParameterMultiMap();
        if (otherParams != null) {
            for (Map.Entry me : otherParams.entrySet()) {
                this.putParameters((String)me.getKey(), (List)me.getValue());
            }
        }
    }

    public BasicInstruction(Instruction other, InstructionStatus status) {
        this(other, null, status);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BasicInstruction{topic=");
        builder.append(this.getTopic());
        builder.append(",id=");
        builder.append(this.getId());
        builder.append(",instructorId=");
        builder.append(this.instructorId);
        builder.append(",status=");
        builder.append(this.getStatus());
        builder.append("}");
        return builder.toString();
    }

    @Override
    public String getInstructorId() {
        return this.instructorId;
    }

    @Override
    public InstructionStatus getStatus() {
        return (InstructionStatus)super.getStatus();
    }
}

