/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.reactor;

import java.util.List;
import net.solarnetwork.domain.InstructionStatus;
import net.solarnetwork.node.reactor.Instruction;
import net.solarnetwork.node.reactor.InstructionExecutionService;
import net.solarnetwork.node.reactor.InstructionHandler;
import net.solarnetwork.node.reactor.InstructionStatus;
import net.solarnetwork.node.reactor.InstructionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleInstructionExecutionService
implements InstructionExecutionService {
    public static final int DEFAULT_EXECUTION_RECEIVED_HOUR_LIMIT = 24;
    private final List<InstructionHandler> handlers;
    private int executionReceivedHourLimit = 24;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public SimpleInstructionExecutionService(List<InstructionHandler> handlers) {
        if (handlers == null) {
            throw new IllegalArgumentException("The handlers argument must not be null.");
        }
        this.handlers = handlers;
    }

    @Override
    public synchronized InstructionStatus executeInstruction(Instruction instruction) {
        long diffMs;
        if (instruction == null) {
            return null;
        }
        long now = System.currentTimeMillis();
        long timeLimitMs = this.executionReceivedHourLimit * 60 * 60 * 1000;
        InstructionStatus startingStatus = instruction.getStatus();
        if (this.handlers.isEmpty()) {
            this.log.trace("No InstructionHandler instances available");
            return null;
        }
        String topic = instruction.getTopic();
        this.log.trace("Passing instruction {} [{}] to handlers", (Object)instruction.getIdentifier(), (Object)topic);
        for (InstructionHandler handler : this.handlers) {
            if (!handler.handlesTopic(topic)) continue;
            try {
                InstructionStatus status = handler.processInstruction(instruction);
                if (status == null || startingStatus != null && startingStatus.equals(status)) continue;
                this.log.info("Instruction {} [{}] state changed to {}", new Object[]{instruction.getIdentifier(), topic, status.getInstructionState()});
                return status;
            }
            catch (Exception e) {
                Throwable root = e;
                while (root.getCause() != null) {
                    root = root.getCause();
                }
                String msg = String.format("Error handling instruction %s [%s] in handler %s: %s", instruction.getIdentifier(), topic, handler, root.getMessage());
                this.log.error(msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
        }
        if (instruction.getInstructionDate() != null && (diffMs = now - instruction.getInstructionDate().toEpochMilli()) > timeLimitMs) {
            String msg = String.format("Instruction %s [%s] not handled within %d hours; declining", instruction.getIdentifier(), topic, this.executionReceivedHourLimit);
            this.log.info(msg);
            return InstructionUtils.createStatus(instruction, InstructionStatus.InstructionState.Declined, InstructionUtils.createErrorResultParameters(msg, "IES.0001"));
        }
        return null;
    }

    public void setExecutionReceivedHourLimit(int executionReceivedHourLimit) {
        this.executionReceivedHourLimit = executionReceivedHourLimit;
    }
}

