/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.runtime;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.solarnetwork.node.job.JobService;
import net.solarnetwork.node.job.JobUtils;
import net.solarnetwork.node.job.ManagedJob;
import net.solarnetwork.node.job.ServiceProvider;
import net.solarnetwork.service.PingTest;
import net.solarnetwork.service.PingTestResult;
import net.solarnetwork.service.ServiceLifecycleObserver;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.SettingSpecifierProvider;
import net.solarnetwork.util.CollectionUtils;
import net.solarnetwork.util.ObjectUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;

public class ManagedJobScheduler
implements ServiceLifecycleObserver,
ConfigurationListener,
PingTest {
    public static final boolean DEFAULT_RANDOMIZED_CRON = true;
    public static final int DEFAULT_JOB_START_DELAY_SECS = 0;
    private static final Logger log = LoggerFactory.getLogger(ManagedJobScheduler.class);
    private final BundleContext bundleContext;
    private final TaskScheduler taskScheduler;
    private boolean randomizedCron = true;
    private MessageSource messageSource;
    private int jobStartDelaySeconds = 0;
    private long startTime = 0L;
    private ScheduledFuture<?> startupTask;
    private final Map<String, ScheduledJobs> pidMap = new HashMap<String, ScheduledJobs>();
    private ServiceRegistration<ConfigurationListener> configurationListenerRef;

    private static String triggerSchedule(Trigger trigger, String schedule) {
        if (trigger instanceof CronTrigger) {
            return ((CronTrigger)trigger).getExpression();
        }
        return schedule;
    }

    private static String jobIdentifier(ManagedJob job, String pid) {
        String settingUid = job.getSettingUid();
        String name = job.getDisplayName();
        StringBuilder buf = new StringBuilder();
        buf.append(settingUid);
        if (!pid.equals(settingUid)) {
            if (pid.startsWith(settingUid)) {
                buf.append(pid.substring(settingUid.length()));
            } else {
                buf.append('-').append(pid);
            }
        } else if (name != null && !name.isEmpty()) {
            buf.append('-').append(name);
        }
        return buf.toString();
    }

    public ManagedJobScheduler(BundleContext bundleContext, TaskScheduler taskScheduler) {
        this.bundleContext = (BundleContext)ObjectUtils.requireNonNullArgument((Object)bundleContext, (String)"bundleContext");
        this.taskScheduler = (TaskScheduler)ObjectUtils.requireNonNullArgument((Object)taskScheduler, (String)"taskScheduler");
    }

    public synchronized void serviceDidStartup() {
        this.startTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this.jobStartDelaySeconds);
        if (this.startupTask != null) {
            this.startupTask.cancel(true);
        }
        this.startupTask = this.taskScheduler.schedule((Runnable)new StartupTask(), new Date(this.startTime));
    }

    public synchronized void serviceDidShutdown() {
        for (Map.Entry<String, ScheduledJobs> e : this.pidMap.entrySet()) {
            ScheduledJobs sjs = e.getValue();
            for (String uid : new HashSet(sjs.jobMap.keySet())) {
                ScheduledJob sj = sjs.removeJob(uid);
                sj.stop();
            }
        }
        this.pidMap.clear();
        if (this.configurationListenerRef != null) {
            this.configurationListenerRef.unregister();
            this.configurationListenerRef = null;
        }
        if (this.startupTask != null) {
            this.startupTask.cancel(true);
        }
    }

    private synchronized void scheduleAllJobs() {
        for (ScheduledJobs sjs : this.pidMap.values()) {
            for (ScheduledJob sj : sjs.jobMap.values()) {
                this.scheduleJob(sj);
            }
        }
        this.startupTask = null;
    }

    public synchronized void registerJob(ManagedJob job, Map<String, ?> properties) {
        if (job == null) {
            return;
        }
        if (job.getSettingUid() == null) {
            throw new RuntimeException("Managed job must provide a settingUid value.");
        }
        if (job.getUid() == null) {
            throw new RuntimeException("Managed job must provide a uid value.");
        }
        String pid = ManagedJobScheduler.servicePid(properties, job.getSettingUid());
        String identifier = ManagedJobScheduler.jobIdentifier(job, pid);
        log.debug("Register job [{}] with props {}", (Object)identifier, properties);
        ArrayList<ServiceRegistration> refs = null;
        Collection<ServiceProvider.ServiceConfiguration> services = job.getServiceConfigurations();
        if (services != null) {
            for (ServiceProvider.ServiceConfiguration conf : services) {
                Object service = conf.getService();
                Object[] interfaces = conf.getInterfaces();
                Dictionary props = CollectionUtils.dictionaryForMap(conf.getProperties());
                if (service == null || interfaces == null || interfaces.length <= 0) continue;
                try {
                    ServiceRegistration ref = this.bundleContext.registerService((String[])interfaces, service, props);
                    log.info("Job [{}] registered managed service {} as {} with props {}", new Object[]{identifier, service, Arrays.toString(interfaces), props});
                    if (refs == null) {
                        refs = new ArrayList<ServiceRegistration>(services.size());
                    }
                    refs.add(ref);
                }
                catch (Exception e) {
                    log.error("Error registering job [{}] managed service {} as {} with props {}: {}", new Object[]{identifier, service, Arrays.toString(interfaces), props, e.toString()});
                }
            }
        }
        ScheduledJob sj = new ScheduledJob(pid, job, refs);
        if (this.configurationListenerRef == null) {
            this.configurationListenerRef = this.bundleContext.registerService(ConfigurationListener.class, (Object)this, null);
        }
        ScheduledJobs sjs = this.pidMap.computeIfAbsent(pid, k -> new ScheduledJobs());
        sjs.addJob(sj);
        if (sjs.settingProviderReg == null) {
            Hashtable<String, Object> settingProps = new Hashtable<String, Object>();
            if (properties.containsKey("service.pid")) {
                ((Dictionary)settingProps).put("service.pid", properties.get("service.pid"));
            }
            ((Dictionary)settingProps).put("settingPid", job.getSettingUid());
            sjs.settingProviderReg = this.bundleContext.registerService(SettingSpecifierProvider.class, (Object)sjs, settingProps);
        }
        if (this.isSchedulerActive()) {
            this.scheduleJob(sj);
        }
    }

    private void scheduleJob(ScheduledJob sj) {
        String expr = sj.job.getSchedule();
        Trigger trigger = this.triggerForSchedule(expr);
        if (trigger != null) {
            ScheduledFuture f = this.taskScheduler.schedule((Runnable)sj, trigger);
            sj.scheduled(f, expr, trigger);
        }
    }

    private boolean isSchedulerActive() {
        return this.jobStartDelaySeconds < 1 || this.startTime > 0L && this.startTime < System.currentTimeMillis();
    }

    public synchronized void unregisterJob(ManagedJob job, Map<String, ?> properties) {
        if (job == null) {
            return;
        }
        String pid = ManagedJobScheduler.servicePid(properties, job.getSettingUid());
        if (pid == null) {
            return;
        }
        log.debug("Unregister job [{}] with props {}", (Object)pid, properties);
        ScheduledJob sj = null;
        ScheduledJobs sjs = this.pidMap.get(pid);
        if (sjs != null) {
            sj = sjs.removeJob(job.getUid());
            if (sjs.isEmpty()) {
                this.pidMap.remove(pid);
            }
        }
        if (sj == null) {
            log.warn("Attempted to unregister job [{}] that wasn't registered", (Object)pid);
            return;
        }
        sj.stop();
    }

    public synchronized void configurationEvent(ConfigurationEvent event) {
        if (event.getType() != 1) {
            return;
        }
        String pid = event.getPid();
        ArrayList sjList = new ArrayList(1);
        ScheduledJobs sjs = this.pidMap.get(pid);
        if (sjs != null) {
            sjList.addAll(sjs.jobMap.values());
        }
        if (sjList.isEmpty()) {
            return;
        }
        Dictionary props = null;
        try {
            ServiceReference caRef = event.getReference();
            ConfigurationAdmin ca = (ConfigurationAdmin)this.bundleContext.getService(caRef);
            Configuration config = ca.getConfiguration(pid, null);
            props = config.getProperties();
        }
        catch (Exception e) {
            log.warn("Exception processing job [{}] configuration update event", (Object)pid, (Object)e);
        }
        for (ScheduledJob sj : sjList) {
            String oldSchedule = sj.schedule;
            String newSchedule = null;
            Object configScheduleExpression = props.get(sj.job.getScheduleSettingKey());
            if (configScheduleExpression != null) {
                newSchedule = configScheduleExpression.toString();
            }
            if (!this.isSchedulerActive() || newSchedule == null || oldSchedule != null && oldSchedule.equalsIgnoreCase(newSchedule)) continue;
            Trigger trigger = this.triggerForSchedule(newSchedule);
            if (trigger != null) {
                sj.stop();
                ScheduledFuture f = this.taskScheduler.schedule((Runnable)sj, trigger);
                sj.scheduled(f, newSchedule, trigger);
                continue;
            }
            if (sj.future == null) continue;
            sj.stop();
            log.info("Stopped job [{}]", new Object[]{sj.identifier, oldSchedule, newSchedule});
        }
    }

    private Trigger triggerForSchedule(String schedule) {
        return JobUtils.triggerForExpression(schedule, TimeUnit.MILLISECONDS, this.randomizedCron);
    }

    private static String servicePid(Map<String, ?> properties, String defaultPid) {
        Object o = properties.get("service.pid");
        return o != null ? o.toString() : defaultPid;
    }

    public String getPingTestId() {
        return "net.solarnetwork.node.runtime.ManagedJobScheduler";
    }

    public String getPingTestName() {
        return "Managed Job Scheduler";
    }

    public long getPingTestMaximumExecutionMilliseconds() {
        return 2000L;
    }

    public synchronized PingTest.Result performPingTest() throws Exception {
        boolean ok = true;
        TreeMap<String, String> errors = new TreeMap<String, String>();
        TreeMap<String, String> all = new TreeMap<String, String>();
        for (Map.Entry<String, ScheduledJobs> e : this.pidMap.entrySet()) {
            ScheduledJobs sjs = e.getValue();
            for (Map.Entry sje : sjs.jobMap.entrySet()) {
                ScheduledJob sj = (ScheduledJob)sje.getValue();
                String ident = sj.identifier;
                Throwable t = sj.throwable;
                if (t != null) {
                    Throwable root = t;
                    while (root.getCause() != null) {
                        root = root.getCause();
                    }
                    errors.put(ident, root.toString());
                }
                all.put(ident, String.format("%s @ %s", sj.identifier, sj.schedule));
            }
        }
        LinkedHashMap<String, TreeMap<String, String>> props = new LinkedHashMap<String, TreeMap<String, String>>();
        if (!errors.isEmpty()) {
            props.put("errors", errors);
        }
        if (!all.isEmpty()) {
            props.put("jobs", all);
        }
        String msg = this.messageSource.getMessage("msg.jobCountStatus", new Object[]{all.size(), errors.size()}, "Scheduler running.", Locale.getDefault());
        return new PingTestResult(ok, msg, props);
    }

    public boolean isRandomizedCron() {
        return this.randomizedCron;
    }

    public void setRandomizedCron(boolean randomizedCron) {
        this.randomizedCron = randomizedCron;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public int getJobStartDelaySeconds() {
        return this.jobStartDelaySeconds;
    }

    public void setJobStartDelaySeconds(int jobStartDelaySeconds) {
        this.jobStartDelaySeconds = jobStartDelaySeconds;
    }

    private final class StartupTask
    implements Runnable {
        private final int delaySecs;

        private StartupTask() {
            this.delaySecs = ManagedJobScheduler.this.getJobStartDelaySeconds();
        }

        @Override
        public void run() {
            log.info("Scheduling jobs after startup delay of {}s", (Object)this.delaySecs);
            ManagedJobScheduler.this.scheduleAllJobs();
        }
    }

    private static class ScheduledJobs
    implements SettingSpecifierProvider {
        private final Map<String, ScheduledJob> jobMap = new HashMap<String, ScheduledJob>(2);
        private ServiceRegistration<SettingSpecifierProvider> settingProviderReg;
        private String settingUid;

        private ScheduledJobs() {
        }

        public String toString() {
            return String.format("ScheduledJobs{%s}", this.settingUid);
        }

        private boolean isEmpty() {
            return this.jobMap.isEmpty();
        }

        private void addJob(ScheduledJob sj) {
            this.settingUid = sj.job.getSettingUid();
            this.jobMap.put(sj.job.getUid(), sj);
        }

        private ScheduledJob removeJob(String uid) {
            ScheduledJob sj = this.jobMap.remove(uid);
            if (this.jobMap.isEmpty() && this.settingProviderReg != null) {
                try {
                    this.settingProviderReg.unregister();
                }
                catch (Exception e) {
                    log.warn("Error unregistering settings provider for job [{}]: {}", (Object)sj.identifier, (Object)e.toString());
                }
            }
            return sj;
        }

        private ScheduledJob anyScheduledJob() {
            ScheduledJob sj;
            if (this.jobMap.isEmpty()) {
                return null;
            }
            Iterator<ScheduledJob> itr = this.jobMap.values().iterator();
            if (itr.hasNext() && (sj = itr.next()) != null) {
                return sj;
            }
            return null;
        }

        public String getSettingUid() {
            return this.settingUid;
        }

        public String getDisplayName() {
            ScheduledJob sj = this.anyScheduledJob();
            return sj != null ? sj.job.getDisplayName() : null;
        }

        public MessageSource getMessageSource() {
            ScheduledJob sj = this.anyScheduledJob();
            return sj != null ? sj.job.getMessageSource() : null;
        }

        public List<SettingSpecifier> getSettingSpecifiers() {
            ArrayList<SettingSpecifier> result = new ArrayList<SettingSpecifier>(8);
            for (ScheduledJob sj : this.jobMap.values()) {
                result.addAll(sj.job.getSettingSpecifiers());
            }
            return result;
        }
    }

    private static final class ScheduledJob
    implements Runnable {
        private final String pid;
        private final ManagedJob job;
        private final List<ServiceRegistration<?>> registeredServices;
        private final String identifier;
        private ScheduledFuture<?> future;
        private String schedule;
        private String triggerSchedule;
        private Throwable throwable;

        private ScheduledJob(String pid, ManagedJob job, List<ServiceRegistration<?>> registeredServices) {
            this.pid = (String)ObjectUtils.requireNonNullArgument((Object)pid, (String)"pid");
            this.job = (ManagedJob)ObjectUtils.requireNonNullArgument((Object)job, (String)"job");
            this.registeredServices = registeredServices;
            this.identifier = ManagedJobScheduler.jobIdentifier(job, this.pid);
        }

        private void scheduled(ScheduledFuture<?> future, String schedule, Trigger trigger) {
            this.future = future;
            String newTriggerSchedule = ManagedJobScheduler.triggerSchedule(trigger, schedule);
            if (this.schedule == null) {
                log.info("Scheduled job [{}] at [{}]", (Object)this.identifier, (Object)newTriggerSchedule);
            } else {
                log.info("Rescheduled job [{}] from [{}] to [{}]", new Object[]{this.identifier, this.triggerSchedule, newTriggerSchedule});
            }
            this.schedule = schedule;
            this.triggerSchedule = newTriggerSchedule;
        }

        private void stop() {
            if (this.future != null && !this.future.isDone()) {
                this.future.cancel(true);
                log.info("Unscheduled job [{}]", (Object)this.identifier);
                if (this.registeredServices != null && !this.registeredServices.isEmpty()) {
                    for (ServiceRegistration<?> reg : this.registeredServices) {
                        try {
                            reg.unregister();
                            log.info("Unregistered job [{}] managed service {}", (Object)this.identifier, reg);
                        }
                        catch (Exception e) {
                            log.warn("Error unregistering job [{}] managed service {}: {}", new Object[]{this.identifier, reg, e.toString()});
                        }
                    }
                    this.registeredServices.clear();
                }
            }
            this.future = null;
        }

        @Override
        public void run() {
            JobService js = this.job.getJobService();
            if (js != null) {
                try {
                    this.throwable = null;
                    this.job.getJobService().executeJobService();
                }
                catch (IOException e) {
                    this.throwable = e;
                    log.warn("Communication error executing job {}: {}", (Object)this.identifier, (Object)e.toString());
                }
                catch (Throwable t) {
                    this.throwable = t;
                    log.error("Error executing job {}: {}", new Object[]{this.identifier, t.getMessage(), t});
                }
            }
        }

        public String toString() {
            return String.format("ScheduledJob{%s @ %s}", this.identifier, this.schedule);
        }
    }
}

