/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.service;

import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public interface PlatformService {
    public static final String EVENT_TOPIC_PLATFORM_STATE_CHANGED = "net/solarnetwork/node/PlatformService/STATE_CHANGED";
    public static final String PLATFORM_STATE_PROPERTY = "platformState";
    public static final String OLD_PLATFORM_STATE_PROPERTY = "oldPlatformState";
    public static final String MSG_TOPIC_PLATFORM_TASK_INFO = "/pub/topic/platform/task";

    public PlatformState activePlatformState();

    public PlatformTaskStatus activePlatformTaskStatus();

    public PlatformTaskInfo activePlatformTaskInfo(Locale var1);

    public void subscribeToActivePlatformTaskInfo(Locale var1);

    public <T> Future<T> performTaskWithState(PlatformState var1, PlatformTask<T> var2);

    public static interface PlatformTask<T>
    extends Callable<T>,
    PlatformTaskStatus {
        public void registerStatusHandler(PlatformTaskStatusHandler var1);
    }

    public static interface PlatformTaskStatusHandler {
        public void taskStatusUpdated(PlatformTaskStatus var1);
    }

    public static interface PlatformTaskStatus {
        public String getTaskId();

        public String getTitle(Locale var1);

        public String getMessage(Locale var1);

        public double getPercentComplete();

        public boolean isComplete();

        public boolean isRestartRequired();
    }

    public static interface PlatformTaskInfo {
        public String getTaskId();

        public String getTitle();

        public String getMessage();

        public double getPercentComplete();

        public boolean isComplete();

        public boolean isRestartRequired();
    }

    public static enum PlatformState {
        Normal,
        UserBlockingSystemTask,
        Restarting;

    }
}

