/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.service.support;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.solarnetwork.domain.datum.Datum;
import net.solarnetwork.domain.datum.DatumSamplesOperations;
import net.solarnetwork.node.service.DatumService;
import net.solarnetwork.node.service.OperationalModesService;
import net.solarnetwork.node.service.PlaceholderService;
import net.solarnetwork.node.service.support.BaseIdentifiable;
import net.solarnetwork.service.DatumFilterStats;
import net.solarnetwork.service.OptionalService;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.support.BasicTextFieldSettingSpecifier;
import net.solarnetwork.settings.support.BasicTitleSettingSpecifier;
import net.solarnetwork.util.DateUtils;
import net.solarnetwork.util.StatCounter;
import org.springframework.context.MessageSource;

public class BaseDatumFilterSupport
extends BaseIdentifiable {
    public static final String DEFAULT_UID = "Default";
    public static final int DEFAULT_STAT_LOG_FREQUENCY = 1000;
    private static final Pattern TAG_COMMA_DELIM = Pattern.compile("\\s*,\\s*");
    protected final StatCounter stats;
    private Pattern sourceId;
    private OperationalModesService opModesService;
    private String requiredOperationalMode;
    private String requiredTag;
    private OptionalService<DatumService> datumService;

    public BaseDatumFilterSupport() {
        this(null);
    }

    public BaseDatumFilterSupport(StatCounter.Stat[] stats) {
        this.stats = new StatCounter("Transform", "", this.log, 1000, (StatCounter.Stat[])DatumFilterStats.values(), stats);
    }

    public static void populateBaseSampleTransformSupportSettings(List<SettingSpecifier> settings) {
        BaseDatumFilterSupport.populateBaseSampleTransformSupportSettings(settings, null, null, null);
    }

    public static void populateBaseSampleTransformSupportSettings(List<SettingSpecifier> settings, String sourceIdDefault, String requiredOperationalModeDefault, String requiredTagDefault) {
        settings.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("sourceId", sourceIdDefault));
        settings.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("requiredOperationalMode", requiredOperationalModeDefault));
        settings.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("requiredTag", requiredTagDefault));
    }

    protected void populateStatusSettings(List<SettingSpecifier> settings) {
        settings.add(0, (SettingSpecifier)new BasicTitleSettingSpecifier("status", this.getStatusMessage(), true, true));
    }

    protected String getStatusMessage() {
        int len = DatumFilterStats.values().length;
        Object[] params = new Object[len + 2];
        for (int i = 0; i < len; ++i) {
            params[i] = this.stats.get((StatCounter.Stat)DatumFilterStats.values()[i]);
        }
        long inputCount = (Long)params[DatumFilterStats.Input.ordinal()];
        long totalTime = (Long)params[DatumFilterStats.ProcessingTimeTotal.ordinal()];
        params[DatumFilterStats.ProcessingTimeTotal.ordinal()] = DateUtils.formatHoursMinutesSeconds((long)totalTime);
        params[params.length - 2] = inputCount > 0L ? String.format("%dms", totalTime / inputCount) : "-";
        long notIgnoredCount = inputCount - (Long)params[DatumFilterStats.Ignored.ordinal()];
        long notIgnoredTime = (Long)params[DatumFilterStats.ProcessingTimeNotIgnoredTotal.ordinal()];
        params[DatumFilterStats.ProcessingTimeNotIgnoredTotal.ordinal()] = DateUtils.formatHoursMinutesSeconds((long)notIgnoredTime);
        params[params.length - 1] = notIgnoredCount > 0L ? String.format("%dms", notIgnoredTime / notIgnoredCount) : "-";
        return this.getMessageSource().getMessage("status.msg", params, Locale.getDefault());
    }

    protected long incrementInputStats() {
        this.stats.incrementAndGet((StatCounter.Stat)DatumFilterStats.Input);
        return System.currentTimeMillis();
    }

    protected void incrementIgnoredStats(long startTime) {
        long end = System.currentTimeMillis();
        this.stats.incrementAndGet((StatCounter.Stat)DatumFilterStats.Ignored);
        this.stats.addAndGet((StatCounter.Stat)DatumFilterStats.ProcessingTimeTotal, end - startTime, true);
    }

    protected void incrementStats(long startTime, DatumSamplesOperations in, DatumSamplesOperations out) {
        long duration = System.currentTimeMillis() - startTime;
        if (out == null) {
            this.stats.incrementAndGet((StatCounter.Stat)DatumFilterStats.Filtered);
        } else if (out != in && out != null && !out.equals(in)) {
            this.stats.incrementAndGet((StatCounter.Stat)DatumFilterStats.Modified);
        }
        this.stats.addAndGet((StatCounter.Stat)DatumFilterStats.ProcessingTimeNotIgnoredTotal, duration, true);
        this.stats.addAndGet((StatCounter.Stat)DatumFilterStats.ProcessingTimeTotal, duration, true);
    }

    public static boolean matchesAny(Pattern[] pats, String value, boolean emptyPatternMatches) {
        if (pats == null || pats.length < 1 || value == null) {
            return true;
        }
        for (Pattern pat : pats) {
            if (!(pat == null ? emptyPatternMatches : pat.matcher(value).find())) continue;
            return true;
        }
        return false;
    }

    protected boolean sourceIdMatches(Datum datum) {
        Pattern sourceIdPat = this.getSourceIdPattern();
        if (!(sourceIdPat == null || datum != null && datum.getSourceId() != null && sourceIdPat.matcher(datum.getSourceId()).find())) {
            this.log.trace("Filter [{}] source ID pattern [{}] does not match datum {}; not filtering", new Object[]{this.getUid(), sourceIdPat, datum});
            return false;
        }
        return true;
    }

    protected boolean operationalModeMatches() {
        String mode = this.getRequiredOperationalMode();
        if (mode == null) {
            return true;
        }
        OperationalModesService service = this.getOpModesService();
        if (service == null) {
            return false;
        }
        boolean result = service.isOperationalModeActive(mode);
        if (!result && this.log.isTraceEnabled()) {
            this.log.trace("Filter [{}] required operational mode [{}] not active; not filtering", (Object)this.getUid(), (Object)mode);
        }
        return result;
    }

    protected boolean tagMatches(Datum datum, DatumSamplesOperations samples) {
        DatumSamplesOperations datumSamples;
        String requiredTagExpr = this.getRequiredTag();
        if (requiredTagExpr == null || requiredTagExpr.isEmpty()) {
            return true;
        }
        String[] requiredTags = TAG_COMMA_DELIM.split(requiredTagExpr.trim());
        this.log.trace("Filter [{}] requires tag expression [{}] for datum {}", new Object[]{this.getUid(), requiredTagExpr, datum});
        boolean hasMatch = this.anyTagMatches(requiredTags, samples);
        if (hasMatch) {
            return true;
        }
        DatumSamplesOperations datumSamplesOperations = datumSamples = datum != null ? datum.asSampleOperations() : null;
        if (datumSamples == null || datumSamples == samples) {
            this.log.trace("Filter [{}] required tag [{}] does not match; not filtering datum {}", new Object[]{this.getUid(), requiredTagExpr, datum});
            return false;
        }
        boolean result = this.anyTagMatches(requiredTags, datumSamples);
        if (!result) {
            this.log.trace("Filter [{}] required tag [{}] does not match; not filtering datum {}", new Object[]{this.getUid(), requiredTagExpr, datum});
        }
        return result;
    }

    private boolean anyTagMatches(String[] tags, DatumSamplesOperations samples) {
        if (samples == null) {
            return false;
        }
        for (String tag : tags) {
            boolean hasTag;
            boolean inverted = false;
            if (tag.startsWith("!")) {
                inverted = true;
                tag = tag.substring(1);
            }
            boolean bl = hasTag = samples != null && samples.hasTag(tag);
            if (hasTag == inverted) continue;
            return true;
        }
        return false;
    }

    protected boolean conditionsMatch(Datum datum, DatumSamplesOperations samples, Map<String, Object> parameters) {
        return this.sourceIdMatches(datum) && this.operationalModeMatches() && this.tagMatches(datum, samples);
    }

    protected Map<String, Object> smartPlaceholders(Map<String, Object> parameters) {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        PlaceholderService.smartCopyPlaceholders(this.getPlaceholderService(), params);
        if (parameters != null) {
            params.putAll(parameters);
        }
        return params;
    }

    protected Pattern getSourceIdPattern() {
        return this.sourceId;
    }

    public String getDescription() {
        String uid = this.getUid();
        MessageSource msg = this.getMessageSource();
        String title = msg.getMessage("title", null, ((Object)((Object)this)).getClass().getSimpleName(), Locale.getDefault());
        if (uid != null && !DEFAULT_UID.equals(uid)) {
            return String.format("%s (%s)", uid, title);
        }
        return title;
    }

    public void setUid(String uid) {
        super.setUid(uid);
        this.stats.setUid(uid);
    }

    public String getSourceId() {
        return this.sourceId != null ? this.sourceId.pattern() : null;
    }

    public void setSourceId(String sourceIdPattern) {
        try {
            this.sourceId = sourceIdPattern != null ? Pattern.compile(sourceIdPattern, 2) : null;
        }
        catch (PatternSyntaxException e) {
            this.log.warn("Error compiling regex [{}]", (Object)sourceIdPattern, (Object)e);
            this.sourceId = null;
        }
    }

    public OperationalModesService getOpModesService() {
        return this.opModesService;
    }

    public void setOpModesService(OperationalModesService opModesService) {
        this.opModesService = opModesService;
    }

    public String getRequiredOperationalMode() {
        return this.requiredOperationalMode;
    }

    public void setRequiredOperationalMode(String requiredOperationalMode) {
        if (requiredOperationalMode != null && requiredOperationalMode.trim().isEmpty()) {
            requiredOperationalMode = null;
        }
        this.requiredOperationalMode = requiredOperationalMode;
    }

    public OptionalService<DatumService> getDatumService() {
        return this.datumService;
    }

    public void setDatumService(OptionalService<DatumService> datumService) {
        this.datumService = datumService;
    }

    public String getRequiredTag() {
        return this.requiredTag;
    }

    public void setRequiredTag(String requiredTag) {
        this.requiredTag = requiredTag;
    }
}

