/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.service.support;

import java.util.Map;
import net.solarnetwork.node.service.BeanConfiguration;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.FactoryBean;

public class BeanConfigurationFactoryBean<T>
implements FactoryBean<T> {
    private BeanConfiguration config = null;
    private Class<T> beanClass = null;
    private boolean singleton = true;
    private Map<String, ?> staticProperties = null;
    private T singletonObject = null;
    private final Object monitor = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getObject() throws Exception {
        if (this.isSingleton()) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.singletonObject == null) {
                    this.singletonObject = this.createObject();
                }
                return this.singletonObject;
            }
        }
        return this.createObject();
    }

    private T createObject() throws InstantiationException, IllegalAccessException {
        T obj = this.beanClass.newInstance();
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess(obj);
        if (this.staticProperties != null) {
            wrapper.setPropertyValues(this.staticProperties);
        }
        wrapper.setPropertyValues(this.config.getConfiguration());
        return obj;
    }

    public Class<T> getObjectType() {
        return this.beanClass;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public BeanConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(BeanConfiguration config) {
        this.config = config;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(Class<T> beanClass) {
        this.beanClass = beanClass;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public Map<String, ?> getStaticProperties() {
        return this.staticProperties;
    }

    public void setStaticProperties(Map<String, ?> staticProperties) {
        this.staticProperties = staticProperties;
    }
}

