/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.service.support;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import net.solarnetwork.io.UnicodeReader;
import net.solarnetwork.node.service.IdentityService;
import net.solarnetwork.node.service.support.BaseIdentifiable;
import net.solarnetwork.security.AuthorizationUtils;
import net.solarnetwork.security.Snws2AuthorizationBuilder;
import net.solarnetwork.service.OptionalService;
import net.solarnetwork.service.SSLService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;

public abstract class HttpClientSupport
extends BaseIdentifiable {
    public static final String ACCEPT_TEXT = "text/*";
    public static final String ACCEPT_JSON = "application/json,text/json";
    public static final int DEFAULT_CONNECTION_TIMEOUT = 55000;
    public static final String HTTP_METHOD_GET = "GET";
    public static final String HTTP_METHOD_POST = "POST";
    private int connectionTimeout = 55000;
    private IdentityService identityService = null;
    private OptionalService<SSLService> sslService = null;
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected InputStream getInputStreamFromURLConnection(URLConnection conn) throws IOException {
        HttpURLConnection httpConn;
        String enc = conn.getContentEncoding();
        String type = conn.getContentType();
        if (conn instanceof HttpURLConnection && ((httpConn = (HttpURLConnection)conn).getResponseCode() < 200 || httpConn.getResponseCode() > 299)) {
            this.log.info("Non-200 HTTP response from {}: {}", (Object)conn.getURL(), (Object)httpConn.getResponseCode());
        }
        this.log.trace("Got content type [{}] encoded as [{}]", (Object)type, (Object)enc);
        InputStream is = conn.getInputStream();
        if ("gzip".equalsIgnoreCase(enc)) {
            is = new GZIPInputStream(is);
        } else if ("deflate".equalsIgnoreCase("enc")) {
            is = new DeflaterInputStream(is);
        }
        return is;
    }

    protected Reader getUnicodeReaderFromURLConnection(URLConnection conn) throws IOException {
        return new BufferedReader((Reader)new UnicodeReader(this.getInputStreamFromURLConnection(conn), null));
    }

    protected URLConnection getURLConnection(String url, String httpMethod) throws IOException {
        return this.getURLConnection(url, httpMethod, ACCEPT_TEXT);
    }

    protected URLConnection getURLConnection(String url, String httpMethod, String accept) throws IOException {
        return this.getURLConnection(url, httpMethod, accept, null);
    }

    protected URLConnection getURLConnection(String url, String httpMethod, String accept, Consumer<URLConnection> connectionCustomizer) throws IOException {
        SSLSocketFactory factory;
        SSLService service;
        URL connUrl;
        try {
            connUrl = new URI(url).toURL();
        }
        catch (URISyntaxException e) {
            throw new IOException("Malformed URL [" + url + "]", e);
        }
        URLConnection conn = connUrl.openConnection();
        if (conn instanceof HttpURLConnection) {
            HttpURLConnection hConn = (HttpURLConnection)conn;
            hConn.setRequestMethod(httpMethod);
        }
        if (this.sslService != null && conn instanceof HttpsURLConnection && (service = (SSLService)this.sslService.service()) != null && (factory = service.getSSLSocketFactory()) != null) {
            HttpsURLConnection hConn = (HttpsURLConnection)conn;
            hConn.setSSLSocketFactory(factory);
        }
        conn.setRequestProperty("Accept", accept);
        conn.setRequestProperty("Accept-Encoding", "gzip,deflate");
        conn.setDoInput(true);
        conn.setDoOutput(HTTP_METHOD_POST.equalsIgnoreCase(httpMethod));
        conn.setConnectTimeout(this.connectionTimeout);
        conn.setReadTimeout(this.connectionTimeout);
        if (connectionCustomizer != null) {
            connectionCustomizer.accept(conn);
        }
        return conn;
    }

    public void setupTokenAuthorization(URLConnection conn, Snws2AuthorizationBuilder builder, Instant requestDate, Map<String, List<String>> headers) {
        if (headers != null) {
            for (Map.Entry<String, List<String>> me : headers.entrySet()) {
                boolean first = true;
                for (String v : me.getValue()) {
                    if (first) {
                        conn.setRequestProperty(me.getKey(), v);
                        continue;
                    }
                    conn.addRequestProperty(me.getKey(), v);
                }
            }
        }
        builder.date(requestDate);
        URL url = conn.getURL();
        String host = url.getHost();
        int port = url.getPort();
        if (port != 80 && port != -1) {
            host = host + ":" + port;
        }
        ((Snws2AuthorizationBuilder)builder.host(host)).path(url.getPath());
        if (this.log.isTraceEnabled()) {
            this.log.trace("Canonical request data: {}", (Object)builder.computeCanonicalRequestMessage());
        }
        conn.setRequestProperty("Date", AuthorizationUtils.AUTHORIZATION_DATE_HEADER_FORMATTER.format(requestDate));
        conn.setRequestProperty("Authorization", builder.build());
    }

    protected void appendXWWWFormURLEncodedValue(StringBuilder buf, String key, Object value) {
        if (value == null) {
            return;
        }
        if (buf.length() > 0) {
            buf.append('&');
        }
        try {
            buf.append(URLEncoder.encode(key, "UTF-8")).append('=').append(URLEncoder.encode(value.toString(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected String xWWWFormURLEncoded(Map<String, ?> data) {
        if (data == null || data.size() < 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, ?> me : data.entrySet()) {
            String key;
            try {
                key = URLEncoder.encode(me.getKey(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            Object val = me.getValue();
            if (val instanceof Collection) {
                for (Object colVal : (Collection)val) {
                    this.appendXWWWFormURLEncodedValue(buf, key, colVal);
                }
                continue;
            }
            if (val.getClass().isArray()) {
                for (Object arrayVal : (Object[])val) {
                    this.appendXWWWFormURLEncodedValue(buf, key, arrayVal);
                }
                continue;
            }
            this.appendXWWWFormURLEncodedValue(buf, key, val);
        }
        return buf.toString();
    }

    protected URLConnection postXWWWFormURLEncodedData(String url, String accept, Map<String, ?> data) throws IOException {
        HttpURLConnection http;
        int status;
        URLConnection conn = this.getURLConnection(url, HTTP_METHOD_POST, accept);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        String body = this.xWWWFormURLEncoded(data);
        this.log.trace("Encoded HTTP POST data {} for {} as {}", new Object[]{data, url, body});
        OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
        FileCopyUtils.copy((Reader)new StringReader(body), (Writer)out);
        if (conn instanceof HttpURLConnection && ((status = (http = (HttpURLConnection)conn).getResponseCode()) < 200 || status > 299)) {
            throw new RuntimeException("HTTP result status not in the 200-299 range: " + http.getResponseCode() + " " + http.getResponseMessage());
        }
        return conn;
    }

    protected String postXWWWFormURLEncodedDataForString(String url, Map<String, ?> data) throws IOException {
        URLConnection conn = this.postXWWWFormURLEncodedData(url, "text/*, application/json", data);
        return FileCopyUtils.copyToString((Reader)this.getUnicodeReaderFromURLConnection(conn));
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public OptionalService<SSLService> getSslService() {
        return this.sslService;
    }

    public void setSslService(OptionalService<SSLService> sslService) {
        this.sslService = sslService;
    }
}

