/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.service.support;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.solarnetwork.domain.KeyValuePair;
import net.solarnetwork.node.dao.SettingDao;
import net.solarnetwork.node.service.PlaceholderService;
import net.solarnetwork.service.OptionalService;
import net.solarnetwork.util.CachedResult;
import net.solarnetwork.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.dao.TransientDataAccessException;

public class SettingsPlaceholderService
implements PlaceholderService {
    public static final String SETTING_KEY = "placeholder";
    public static final int DEFAULT_CACHE_SECONDS = 20;
    public static final int DEFAULT_DAO_RETRY_COUNT = 3;
    private final OptionalService<SettingDao> settingDao;
    private Path staticPropertiesPath;
    private int cacheSeconds = 20;
    private AsyncTaskExecutor taskExecutor;
    private int daoRetryCount = 3;
    private Map<String, ?> staticProps;
    private volatile CachedResult<Map<String, ?>> placeholdersCache;
    private volatile Future<Map<String, ?>> refreshCacheTask;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public SettingsPlaceholderService(OptionalService<SettingDao> settingDao) {
        this.settingDao = settingDao;
    }

    @Override
    public String resolvePlaceholders(String s, Map<String, ?> parameters) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        if (!StringUtils.NAMES_PATTERN.matcher(s).find()) {
            return s;
        }
        String resolved = s;
        Map<String, ?> placeholders = this.allPlaceholders(parameters);
        String result = StringUtils.expandTemplateString((String)resolved, placeholders);
        if (this.log.isTraceEnabled() && !result.equals(s)) {
            this.log.trace("Placeholders in [{}] resolved to [{}]", (Object)s, (Object)result);
        }
        return result;
    }

    @Override
    public <T> void mapPlaceholders(Map<String, T> destination, Function<Stream<Map.Entry<String, ?>>, Stream<Map.Entry<String, T>>> filter) {
        Map<String, ?> placeholders = this.allPlaceholders(null);
        if (placeholders == null || placeholders.isEmpty()) {
            return;
        }
        if (filter == null) {
            destination.putAll(placeholders);
        } else {
            Stream input = placeholders.entrySet().stream();
            Stream<Map.Entry<String, Map.Entry>> output = filter.apply(input);
            output.forEach(e -> destination.put((String)e.getKey(), e.getValue()));
        }
    }

    @Override
    public <T> void copyPlaceholders(Map<String, T> destination, Predicate<Map.Entry<String, T>> filter) {
        Map<String, ?> placeholders = this.allPlaceholders(null);
        if (placeholders == null || placeholders.isEmpty()) {
            return;
        }
        if (filter == null) {
            destination.putAll(placeholders);
        } else {
            placeholders.entrySet().stream().filter(filter).forEach(e -> destination.put((String)e.getKey(), e.getValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ?> allPlaceholders(Map<String, ?> parameters) {
        Map result = null;
        if (this.cacheSeconds > 0 && this.settingDao.service() != null) {
            CachedResult<Map<String, ?>> cached = this.placeholdersCache;
            Map map = result = cached != null ? (Map)cached.getResult() : null;
            if (result == null || cached == null || !cached.isValid()) {
                AsyncTaskExecutor executor = this.taskExecutor;
                SettingsPlaceholderService settingsPlaceholderService = this;
                synchronized (settingsPlaceholderService) {
                    if (this.refreshCacheTask == null || this.refreshCacheTask.isDone()) {
                        CacheRefreshTask task = new CacheRefreshTask();
                        try {
                            if (executor != null && result != null) {
                                this.refreshCacheTask = executor.submit((Callable)task);
                            } else {
                                this.log.debug("Loading initial setting placeholder values");
                                result = (Map)task.call();
                            }
                        }
                        catch (Exception e) {
                            this.log.error("Error loading placeholders: {}", (Throwable)e);
                        }
                    }
                }
            }
        }
        if (result == null) {
            result = this.allPlaceholdersWithoutCache();
        }
        return this.placeholdersMergedWithParameters(result, parameters);
    }

    private Map<String, ?> placeholdersMergedWithParameters(final Map<String, ?> placeholders, final Map<String, ?> parameters) {
        if (parameters == null) {
            return placeholders;
        }
        if (placeholders == null) {
            return parameters;
        }
        return new AbstractMap<String, Object>(){

            @Override
            public Object get(Object key) {
                if (parameters != null && parameters.containsKey(key)) {
                    return parameters.get(key);
                }
                return placeholders.get(key);
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return null;
            }
        };
    }

    private Map<String, Object> allPlaceholdersWithoutCache() {
        List<KeyValuePair> kp = this.settingValues();
        Map<String, ?> props = this.staticPropValues();
        if (kp != null && !kp.isEmpty() || props != null && !props.isEmpty()) {
            HashMap<String, Object> mergedProps = new HashMap<String, Object>((props != null ? props.size() : 1) + (kp != null ? kp.size() : 1));
            if (props != null) {
                mergedProps.putAll(props);
            }
            if (kp != null) {
                for (KeyValuePair p : kp) {
                    mergedProps.put(p.getKey(), p.getValue());
                }
            }
            return mergedProps;
        }
        return null;
    }

    private Map<String, ?> staticPropValues() {
        Map<String, ?> props = this.staticProps;
        if (props == null) {
            props = this.loadStaticProps();
        }
        return props;
    }

    private List<KeyValuePair> settingValues() {
        SettingDao dao = (SettingDao)OptionalService.service(this.settingDao);
        if (dao != null) {
            return this.settingValues(dao, this.daoRetryCount);
        }
        this.log.warn("SettingDao not available for resolving placeholders.");
        return null;
    }

    private List<KeyValuePair> settingValues(SettingDao dao, int i) {
        try {
            return dao.getSettingValues(SETTING_KEY);
        }
        catch (TransientDataAccessException e) {
            if (i > 0) {
                this.log.warn("Transient exception loading placeholder values from SettingDao, will retry up to {} more times: {}", (Object)i, (Object)e);
                return this.settingValues(dao, i - 1);
            }
        }
        catch (Exception e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            this.log.warn("Exception loading placeholder values from SettingDao: {}", (Object)t.toString());
        }
        return null;
    }

    @Override
    public void registerParameters(Map<String, ?> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        SettingDao dao = (SettingDao)OptionalService.service(this.settingDao);
        if (dao == null) {
            this.log.warn("SettingDao not avaialble for registering parameters: {}", parameters);
            return;
        }
        for (Map.Entry<String, ?> me : parameters.entrySet()) {
            if (me.getKey() == null || me.getValue() == null) continue;
            dao.storeSetting(SETTING_KEY, me.getKey(), me.getValue().toString());
        }
    }

    private synchronized Map<String, ?> loadStaticProps() {
        if (this.staticProps != null) {
            return this.staticProps;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        Path p = this.staticPropertiesPath;
        if (p != null) {
            if (Files.isDirectory(p, new LinkOption[0])) {
                try {
                    Files.list(p).forEach(e -> this.loadProps((Path)e, (Map<String, Object>)params));
                }
                catch (IOException e2) {
                    this.log.error("Unable to list properties files in {}: {}", (Object)p, (Object)e2.getMessage());
                }
            } else if (Files.exists(p, new LinkOption[0])) {
                this.loadProps(p, params);
            }
        }
        this.staticProps = params;
        return params;
    }

    private void loadProps(Path p, Map<String, Object> dest) {
        if (p.getFileName().toString().endsWith(".properties")) {
            this.log.info("Loading placeholder properties from {}", (Object)p);
            Properties props = new Properties();
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(p, new OpenOption[0]));){
                props.load(in);
                for (Map.Entry<Object, Object> me : props.entrySet()) {
                    if (me.getKey() == null) continue;
                    dest.put(me.getKey().toString(), me.getValue());
                }
            }
            catch (IOException e) {
                this.log.error("Unable to load properties file {} (will ignore): {}", (Object)p, (Object)e.getMessage());
            }
        }
    }

    public Path getStaticPropertiesPath() {
        return this.staticPropertiesPath;
    }

    public void setStaticPropertiesPath(Path staticPropertiesPath) {
        this.staticPropertiesPath = staticPropertiesPath;
    }

    public int getCacheSeconds() {
        return this.cacheSeconds;
    }

    public void setCacheSeconds(int cacheSeconds) {
        this.cacheSeconds = cacheSeconds;
    }

    public AsyncTaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(AsyncTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public int getDaoRetryCount() {
        return this.daoRetryCount;
    }

    public void setDaoRetryCount(int daoRetryCount) {
        this.daoRetryCount = daoRetryCount;
    }

    private final class CacheRefreshTask
    implements Callable<Map<String, ?>> {
        private CacheRefreshTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, ?> call() throws Exception {
            CachedResult cached;
            SettingsPlaceholderService settingsPlaceholderService = SettingsPlaceholderService.this;
            synchronized (settingsPlaceholderService) {
                cached = SettingsPlaceholderService.this.placeholdersCache;
                if (cached != null && cached.isValid()) {
                    return (Map)cached.getResult();
                }
            }
            SettingsPlaceholderService.this.log.debug("Refreshing placeholder cache in background");
            try {
                Map placeholders = SettingsPlaceholderService.this.allPlaceholdersWithoutCache();
                SettingsPlaceholderService settingsPlaceholderService2 = SettingsPlaceholderService.this;
                synchronized (settingsPlaceholderService2) {
                    SettingsPlaceholderService.this.placeholdersCache = new CachedResult((Object)placeholders, (long)SettingsPlaceholderService.this.cacheSeconds, TimeUnit.SECONDS);
                }
                SettingsPlaceholderService.this.log.debug("Cached {} placeholder values", (Object)(placeholders != null ? placeholders.size() : 0));
                return placeholders;
            }
            catch (Exception e) {
                Throwable root = e;
                while (root.getCause() != null) {
                    root = root.getCause();
                }
                SettingsPlaceholderService.this.log.warn("Error refreshing placeholders from SettingDao; returning cached values: {}", (Object)root.toString());
                return cached != null ? (Map)cached.getResult() : null;
            }
        }
    }
}

