/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.service.support;

import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.solarnetwork.node.service.support.HttpClientSupport;
import net.solarnetwork.service.OptionalService;
import net.solarnetwork.util.ClassUtils;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlServiceSupport
extends HttpClientSupport {
    public static final String ATTR_NODE_ID = "node-id";
    private NamespaceContext nsContext = null;
    private DocumentBuilderFactory docBuilderFactory = null;
    private XPathFactory xpathFactory = null;
    private TransformerFactory transformerFactory = null;
    private OptionalService<EventAdmin> eventAdmin;

    public void init() {
    }

    public Map<String, XPathExpression> getXPathExpressionMap(Map<String, String> xpathMap) {
        LinkedHashMap<String, XPathExpression> datumXPathMap = new LinkedHashMap<String, XPathExpression>();
        for (Map.Entry<String, String> me : xpathMap.entrySet()) {
            try {
                XPath xp = this.getXpathFactory().newXPath();
                if (this.getNsContext() != null) {
                    xp.setNamespaceContext(this.getNsContext());
                }
                datumXPathMap.put(me.getKey(), xp.compile(me.getValue()));
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException(e);
            }
        }
        return datumXPathMap;
    }

    public Templates getTemplates(Resource resource) {
        try {
            return this.getTransformerFactory().newTemplates(new StreamSource(resource.getInputStream()));
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("Unable to load XSLT from resource [" + resource + ']');
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load XSLT from resource [" + resource + ']');
        }
    }

    public Source getSimpleSource(Object o, String elementName) {
        Document dom = this.getSimpleDocument(o, elementName);
        return this.getSource(dom);
    }

    public Document getSimpleDocument(Object o, String elementName) {
        Document dom = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            dom = this.getDocBuilderFactory().newDocumentBuilder().newDocument();
            Element root = dom.createElement(elementName);
            dom.appendChild(root);
            Map props = ClassUtils.getBeanProperties((Object)o, null);
            for (Map.Entry me : props.entrySet()) {
                Object val = me.getValue();
                if (val instanceof Date) {
                    val = sdf.format((Date)val);
                }
                root.setAttribute((String)me.getKey(), val.toString());
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace("attribute name: " + (String)me.getKey() + " attribute value: " + val.toString());
            }
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        return dom;
    }

    public Document getDocument(BeanWrapper bean, String elementName) {
        Document dom = null;
        try {
            dom = this.getDocBuilderFactory().newDocumentBuilder().newDocument();
            dom.appendChild(this.getElement(bean, elementName, dom));
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        return dom;
    }

    public Element getElement(BeanWrapper bean, Document dom) {
        String elementName = bean.getWrappedInstance().getClass().getSimpleName();
        return this.getElement(bean, elementName, dom);
    }

    public Element getElement(BeanWrapper bean, String elementName, Document dom) {
        PropertyDescriptor[] props = bean.getPropertyDescriptors();
        Element root = null;
        root = dom.createElement(elementName);
        for (int i = 0; i < props.length; ++i) {
            String propName;
            PropertyDescriptor prop = props[i];
            if (prop.getReadMethod() == null || "class".equals(propName = prop.getName())) continue;
            Object propValue = null;
            PropertyEditor editor = bean.findCustomEditor(prop.getPropertyType(), prop.getName());
            if (editor != null) {
                editor.setValue(bean.getPropertyValue(propName));
                propValue = editor.getAsText();
            } else {
                propValue = bean.getPropertyValue(propName);
            }
            if (propValue == null) continue;
            if (this.log.isTraceEnabled()) {
                this.log.trace("attribute name: " + propName + " attribute value: " + propValue);
            }
            root.setAttribute(propName, propValue.toString());
        }
        return root;
    }

    public Source getSource(BeanWrapper bean, String elementName) {
        Document dom = this.getDocument(bean, elementName);
        return this.getSource(dom);
    }

    public Source getSource(Document dom) {
        DOMSource result = new DOMSource(dom);
        if (this.log.isDebugEnabled()) {
            this.log.debug("XML: " + this.getXmlAsString(result, true));
        }
        return result;
    }

    public String getXmlAsString(Source source, boolean indent) {
        ByteArrayOutputStream byos = new ByteArrayOutputStream();
        try {
            Transformer xform = this.getTransformerFactory().newTransformer();
            if (indent) {
                xform.setOutputProperty("indent", "yes");
                xform.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            }
            xform.transform(source, new StreamResult(byos));
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        return byos.toString();
    }

    public void extractBeanDataFromXml(Object obj, Node xml, Map<String, XPathExpression> xpathMap) {
        BeanWrapper bean = obj instanceof BeanWrapper ? (BeanWrapper)obj : PropertyAccessorFactory.forBeanPropertyAccess((Object)obj);
        this.registerCustomEditors(bean);
        for (Map.Entry<String, XPathExpression> me : xpathMap.entrySet()) {
            try {
                String val = (String)me.getValue().evaluate(xml, XPathConstants.STRING);
                if (val == null || "".equals(val)) continue;
                bean.setPropertyValue(me.getKey(), (Object)val);
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void registerCustomEditors(BeanWrapper bean) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputSource getInputSourceFromURLConnection(URLConnection conn) throws IOException {
        Reader resp = null;
        try {
            resp = this.getUnicodeReaderFromURLConnection(conn);
            String respXml = FileCopyUtils.copyToString((Reader)resp);
            this.log.trace("Got response XML from URL [{}]:\n{}", (Object)conn.getURL(), (Object)respXml);
            if (respXml.length() < 1) {
                throw new IOException("Empty response from [" + conn.getURL() + "]");
            }
            InputSource inputSource = new InputSource(new StringReader(respXml));
            return inputSource;
        }
        finally {
            if (resp != null) {
                try {
                    resp.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public InputSource webFormPost(BeanWrapper bean, String url, Map<String, ?> attributes) {
        try {
            URLConnection conn = this.getURLConnection(url, "POST");
            OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
            this.writeURLEncodedBeanProperties(bean, attributes, out);
            return this.getInputSourceFromURLConnection(conn);
        }
        catch (IOException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("IOException posting " + bean + " to " + url, (Throwable)e);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Unable to post data to " + url + ": " + e.getMessage());
            }
            throw new RuntimeException(e);
        }
    }

    private void writeURLEncodedBeanProperties(BeanWrapper bean, Map<String, ?> attributes, Writer out) throws IOException {
        PropertyDescriptor[] props = bean.getPropertyDescriptors();
        boolean propsWritten = false;
        if (attributes != null && attributes.containsKey(ATTR_NODE_ID)) {
            out.write("nodeId=" + attributes.get(ATTR_NODE_ID));
            propsWritten = true;
        }
        for (int i = 0; i < props.length; ++i) {
            String propName;
            PropertyDescriptor prop = props[i];
            if (prop.getReadMethod() == null || "class".equals(propName = prop.getName())) continue;
            Object propValue = null;
            if (attributes != null && attributes.containsKey(propName)) {
                propValue = attributes.get(propName);
            } else {
                PropertyEditor editor = bean.findCustomEditor(prop.getPropertyType(), prop.getName());
                if (editor != null) {
                    editor.setValue(bean.getPropertyValue(propName));
                    propValue = editor.getAsText();
                } else {
                    propValue = bean.getPropertyValue(propName);
                }
            }
            if (propValue == null) continue;
            if (propsWritten) {
                out.write("&");
            }
            out.write(propName);
            out.write("=");
            out.write(URLEncoder.encode(propValue.toString(), "UTF-8"));
            propsWritten = true;
        }
        out.flush();
        out.close();
    }

    public InputSource webFormGet(BeanWrapper bean, String url, Map<String, ?> attributes) {
        try {
            String getUrl = url;
            if (bean != null) {
                StringWriter out = new StringWriter();
                this.writeURLEncodedBeanProperties(bean, attributes, out);
                getUrl = getUrl + '?' + out.toString();
            }
            URLConnection conn = this.getURLConnection(getUrl, "GET");
            return this.getInputSourceFromURLConnection(conn);
        }
        catch (IOException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("IOException getting " + bean + " from " + url, (Throwable)e);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Unable to get data: " + e.getMessage());
            }
            throw new RuntimeException(e);
        }
    }

    public void webFormPostForBean(BeanWrapper bean, Object obj, String url, Map<String, ?> attributes, Map<String, XPathExpression> xpathMap) {
        Document doc;
        InputSource is = this.webFormPost(bean, url, attributes);
        try {
            doc = this.getDocBuilderFactory().newDocumentBuilder().parse(is);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        this.extractBeanDataFromXml(obj, doc.getDocumentElement(), xpathMap);
    }

    public void webFormGetForBean(BeanWrapper bean, Object obj, String url, Map<String, ?> attributes, Map<String, XPathExpression> xpathMap) {
        Document doc;
        InputSource is = this.webFormGet(bean, url, attributes);
        try {
            doc = this.getDocBuilderFactory().newDocumentBuilder().parse(is);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        this.extractBeanDataFromXml(obj, doc.getDocumentElement(), xpathMap);
    }

    public Long extractTrackingId(InputSource xml, XPathExpression xp, String xpath) {
        Double tid;
        try {
            tid = (Double)xp.evaluate(xml, XPathConstants.NUMBER);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        if (tid.isNaN()) {
            this.log.warn("Unable to extract tracking ID via XPath [{}]", (Object)xpath);
            return null;
        }
        return tid.longValue();
    }

    public Long webFormPostForTrackingId(BeanWrapper bean, String url, XPathExpression trackingIdXPath, String xpath, Map<String, ?> attributes) {
        InputSource is = this.webFormPost(bean, url, attributes);
        return this.extractTrackingId(is, trackingIdXPath, xpath);
    }

    public final void postEvent(Event event) {
        EventAdmin ea;
        EventAdmin eventAdmin = ea = this.eventAdmin == null ? null : (EventAdmin)this.eventAdmin.service();
        if (ea == null || event == null) {
            return;
        }
        ea.postEvent(event);
    }

    public NamespaceContext getNsContext() {
        return this.nsContext;
    }

    public void setNsContext(NamespaceContext nsContext) {
        this.nsContext = nsContext;
    }

    public DocumentBuilderFactory getDocBuilderFactory() {
        DocumentBuilderFactory f = this.docBuilderFactory;
        if (f == null) {
            f = DocumentBuilderFactory.newInstance();
            f.setNamespaceAware(true);
            this.docBuilderFactory = f;
        }
        return f;
    }

    public void setDocBuilderFactory(DocumentBuilderFactory docBuilderFactory) {
        this.docBuilderFactory = docBuilderFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XPathFactory getXpathFactory() {
        XPathFactory f = this.xpathFactory;
        if (f == null) {
            ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader newClassLoader = XPathFactory.class.getClassLoader();
            if (newClassLoader != null) {
                Thread.currentThread().setContextClassLoader(newClassLoader);
            }
            try {
                this.xpathFactory = f = XPathFactory.newInstance();
            }
            finally {
                if (newClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(origClassLoader);
                }
            }
        }
        return f;
    }

    public void setXpathFactory(XPathFactory xpathFactory) {
        this.xpathFactory = xpathFactory;
    }

    public TransformerFactory getTransformerFactory() {
        TransformerFactory f = this.transformerFactory;
        if (f == null) {
            this.transformerFactory = f = TransformerFactory.newInstance();
        }
        return f;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public OptionalService<EventAdmin> getEventAdmin() {
        return this.eventAdmin;
    }

    public void setEventAdmin(OptionalService<EventAdmin> eventAdmin) {
        this.eventAdmin = eventAdmin;
    }
}

