/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import net.solarnetwork.node.settings.SettingValueBean;
import net.solarnetwork.node.settings.SettingsUpdates;

public class SettingsCommand
implements SettingsUpdates {
    private String providerKey;
    private String instanceKey;
    private List<SettingValueBean> values;
    private boolean force;
    private final Iterable<Pattern> settingKeyPatternsToClean;

    public SettingsCommand() {
        this(null);
    }

    public SettingsCommand(boolean force) {
        this(null);
        this.force = force;
    }

    public SettingsCommand(List<SettingValueBean> values) {
        this(values, null);
    }

    public SettingsCommand(List<SettingValueBean> values, Iterable<Pattern> settingKeyPatternsToClean) {
        this.setValues(values != null ? values : new ArrayList(8));
        this.settingKeyPatternsToClean = settingKeyPatternsToClean != null ? settingKeyPatternsToClean : Collections.emptyList();
    }

    @Override
    public boolean hasSettingKeyPatternsToClean() {
        if (this.settingKeyPatternsToClean instanceof Collection) {
            return !((Collection)this.settingKeyPatternsToClean).isEmpty();
        }
        if (this.settingKeyPatternsToClean != null) {
            Iterator<Pattern> itr = this.settingKeyPatternsToClean.iterator();
            return itr.hasNext();
        }
        return false;
    }

    @Override
    public boolean hasSettingValueUpdates() {
        return this.force || this.values != null && !this.values.isEmpty();
    }

    @Override
    public Iterable<Pattern> getSettingKeyPatternsToClean() {
        return this.settingKeyPatternsToClean;
    }

    @Override
    public Iterable<? extends SettingsUpdates.Change> getSettingValueUpdates() {
        return this.getValues();
    }

    public List<SettingValueBean> getValues() {
        return this.values;
    }

    public void setValues(List<SettingValueBean> values) {
        this.values = values;
    }

    public String getProviderKey() {
        return this.providerKey;
    }

    public void setProviderKey(String providerKey) {
        this.providerKey = providerKey;
    }

    public String getInstanceKey() {
        return this.instanceKey;
    }

    public void setInstanceKey(String instanceKey) {
        this.instanceKey = instanceKey;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }
}

