/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.setup;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Set;
import net.solarnetwork.node.setup.BaseStaticSetupResource;
import net.solarnetwork.node.setup.SetupResourceScope;
import net.solarnetwork.node.setup.SetupResourceUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class ClasspathSetupResource
extends BaseStaticSetupResource {
    private final String path;
    private final Class<?> clazz;

    public ClasspathSetupResource(String uid, String path, Class<?> clazz, String contentType) throws IOException {
        this(uid, path, clazz, contentType, SetupResourceUtils.localeForPath(path), 86400, null, null);
    }

    public ClasspathSetupResource(String uid, String path, Class<?> clazz, String contentType, Set<String> consumerTypes) throws IOException {
        this(uid, path, clazz, contentType, SetupResourceUtils.localeForPath(path), 86400, consumerTypes, null);
    }

    public ClasspathSetupResource(String uid, String path, Class<?> clazz, String contentType, Set<String> consumerTypes, Set<String> roles) throws IOException {
        this(uid, path, clazz, contentType, SetupResourceUtils.localeForPath(path), 86400, consumerTypes, roles);
    }

    public ClasspathSetupResource(String uid, String path, Class<?> clazz, String contentType, Locale locale, int cacheSeconds) throws IOException {
        this(uid, path, clazz, contentType, locale, cacheSeconds, null, null);
    }

    public ClasspathSetupResource(String uid, String path, Class<?> clazz, String contentType, Locale locale, int cacheSeconds, Set<String> consumerTypes, Set<String> roles) throws IOException {
        this(uid, path, clazz, contentType, locale, cacheSeconds, consumerTypes, roles, SetupResourceScope.Default);
    }

    public ClasspathSetupResource(String uid, String path, Class<?> clazz, String contentType, Locale locale, int cacheSeconds, Set<String> consumerTypes, Set<String> roles, SetupResourceScope scope) throws IOException {
        super(uid, contentType, locale, cacheSeconds, consumerTypes, roles, (Resource)new ClassPathResource(path, clazz), scope);
        this.path = path;
        this.clazz = clazz;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.clazz.getResourceAsStream(this.path);
    }
}

