/* ==================================================================
 * ExtendedSettingSpecifierProviderFactory.java - 19/11/2021 4:50:59 PM
 * 
 * Copyright 2021 SolarNetwork.net Dev Team
 * 
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of 
 * the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 
 * 02111-1307 USA
 * ==================================================================
 */

package net.solarnetwork.node.settings;

import java.util.Set;
import net.solarnetwork.settings.SettingSpecifierProviderFactory;

/**
 * Extension of {@link SettingSpecifierProviderFactory} to support more
 * information in SolarNode.
 * 
 * @author matt
 * @version 1.0
 * @since 2.1
 */
public interface ExtendedSettingSpecifierProviderFactory extends SettingSpecifierProviderFactory {

	/**
	 * Get the {@link net.solarnetwork.settings.SettingSpecifierProvider}
	 * instance IDs available.
	 * 
	 * @return the available provider instance IDs
	 */
	Set<String> getSettingSpecifierProviderInstanceIds();

}
