/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.backup;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.solarnetwork.node.backup.BackupResource;

public class ZipEntryBackupResource
implements BackupResource {
    private final ZipFile archiveFile;
    private final ZipEntry entry;
    private final String providerKey;

    public ZipEntryBackupResource(ZipFile archiveFile, ZipEntry entry) {
        this(archiveFile, entry, null);
    }

    public ZipEntryBackupResource(ZipFile archiveFile, ZipEntry entry, String providerKey) {
        int providerIndex;
        this.archiveFile = archiveFile;
        this.entry = entry;
        if (providerKey == null && (providerIndex = entry.getName().indexOf(47)) != -1) {
            providerKey = entry.getName().substring(0, providerIndex);
        }
        this.providerKey = providerKey;
    }

    @Override
    public String getProviderKey() {
        return this.providerKey;
    }

    @Override
    public String getBackupPath() {
        return this.entry.getName();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.archiveFile.getInputStream(this.entry);
    }

    @Override
    public long getModificationDate() {
        return this.entry.getTime();
    }

    @Override
    public String getSha256Digest() {
        return null;
    }
}

