/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.domain;

import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public class Setting {
    private String key;
    private String type;
    private String value;
    private Date modified;
    private Set<SettingFlag> flags;

    public Setting() {
    }

    public Setting(String key, String type, String value, Set<SettingFlag> flags) {
        this.key = key;
        this.type = type;
        this.value = value;
        this.flags = flags;
    }

    public String toString() {
        return "Setting{key=" + this.key + ",type=" + this.type + ",flags=" + this.flags + '}';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Setting other = (Setting)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Set<SettingFlag> getFlags() {
        return this.flags;
    }

    public void setFlags(Set<SettingFlag> flags) {
        this.flags = flags;
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public static enum SettingFlag {
        IgnoreModificationDate(0),
        Volatile(1);

        private final int key;

        private SettingFlag(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        public static SettingFlag forKey(int key) {
            switch (key) {
                case 0: {
                    return IgnoreModificationDate;
                }
                case 1: {
                    return Volatile;
                }
            }
            throw new IllegalArgumentException(key + " is not a valid key");
        }

        public static Set<SettingFlag> setForMask(int mask) {
            HashSet<SettingFlag> maskSet = new HashSet<SettingFlag>();
            for (SettingFlag flag : EnumSet.allOf(SettingFlag.class)) {
                if ((mask >> flag.getKey() & 1) != 1) continue;
                maskSet.add(flag);
            }
            if (maskSet.size() < 1) {
                return Collections.emptySet();
            }
            return EnumSet.copyOf(maskSet);
        }

        public static int maskForSet(Set<SettingFlag> set) {
            int mask = 0;
            if (set != null) {
                for (SettingFlag flag : set) {
                    mask |= 1 << flag.getKey();
                }
            }
            return mask;
        }
    }
}

