/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.domain.datum;

import java.util.EnumSet;
import net.solarnetwork.domain.AcPhase;
import net.solarnetwork.domain.datum.DatumSamplesType;
import net.solarnetwork.node.domain.AcEnergyDataAccessor;
import net.solarnetwork.node.domain.datum.EnergyDatum;

public interface AcEnergyDatum
extends EnergyDatum,
net.solarnetwork.domain.datum.AcEnergyDatum {
    default public void populatePhaseMeasurementProperties(AcEnergyDataAccessor data) {
        EnumSet<AcPhase> phases = EnumSet.of(AcPhase.PhaseA, AcPhase.PhaseB, AcPhase.PhaseC);
        for (AcPhase phase : phases) {
            AcEnergyDataAccessor acc = data.accessorForPhase(phase);
            this.setCurrent(phase, acc.getCurrent());
            this.setVoltage(phase, acc.getVoltage());
            this.setLineVoltage(phase, acc.getLineVoltage());
        }
    }

    default public void setAcPhase(AcPhase value) {
        this.asMutableSampleOperations().putSampleValue(DatumSamplesType.Status, "phase", (Object)value.toString());
    }

    default public void setRealPower(Integer value) {
        this.asMutableSampleOperations().putSampleValue(DatumSamplesType.Instantaneous, "realPower", (Object)value);
    }

    default public void setApparentPower(Integer value) {
        this.asMutableSampleOperations().putSampleValue(DatumSamplesType.Instantaneous, "apparentPower", (Object)value);
    }

    default public void setReactivePower(Integer value) {
        this.asMutableSampleOperations().putSampleValue(DatumSamplesType.Instantaneous, "reactivePower", (Object)value);
    }

    default public void setPowerFactor(Float value) {
        this.asMutableSampleOperations().putSampleValue(DatumSamplesType.Instantaneous, "powerFactor", (Object)value);
    }

    default public void setEffectivePowerFactor(Float value) {
        this.asMutableSampleOperations().putSampleValue(DatumSamplesType.Instantaneous, "effectivePowerFactor", (Object)value);
    }

    default public void setFrequency(Float value) {
        this.asMutableSampleOperations().putSampleValue(DatumSamplesType.Instantaneous, "frequency", (Object)value);
    }

    default public void setVoltage(Float value) {
        this.asMutableSampleOperations().putSampleValue(DatumSamplesType.Instantaneous, "voltage", (Object)value);
    }

    default public void setVoltage(AcPhase phase, Float value) {
        this.asMutableSampleOperations().putSampleValue(DatumSamplesType.Instantaneous, phase.withKey("voltage"), (Object)value);
    }

    default public void setCurrent(Float value) {
        this.asMutableSampleOperations().putSampleValue(DatumSamplesType.Instantaneous, "current", (Object)value);
    }

    default public void setCurrent(AcPhase phase, Float value) {
        this.asMutableSampleOperations().putSampleValue(DatumSamplesType.Instantaneous, phase.withKey("current"), (Object)value);
    }

    default public void setNeutralCurrent(Float value) {
        this.asMutableSampleOperations().putSampleValue(DatumSamplesType.Instantaneous, "neutralCurrent", (Object)value);
    }

    default public void setPhaseVoltage(Float value) {
        this.asMutableSampleOperations().putSampleValue(DatumSamplesType.Instantaneous, "phaseVoltage", (Object)value);
    }

    default public void setLineVoltage(Float value) {
        this.asMutableSampleOperations().putSampleValue(DatumSamplesType.Instantaneous, "lineVoltage", (Object)value);
    }

    default public void setLineVoltage(AcPhase phase, Float value) {
        this.asMutableSampleOperations().putSampleValue(DatumSamplesType.Instantaneous, phase.withLineKey("voltage"), (Object)value);
    }
}

