/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.runtime;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.solarnetwork.domain.Result;
import net.solarnetwork.node.runtime.SimplePlatformTaskInfo;
import net.solarnetwork.node.service.PlatformService;
import net.solarnetwork.service.OptionalService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class DefaultPlatformService
implements PlatformService {
    private final AtomicInteger activeState = new AtomicInteger(PlatformService.PlatformState.Normal.ordinal());
    private final AtomicReference<PlatformService.PlatformTask<?>> activeSingletonTask = new AtomicReference();
    private ExecutorService singletonExecutorService = DefaultPlatformService.defaultSingletonExecutorService();
    private OptionalService<EventAdmin> eventAdmin;
    private OptionalService<SimpMessageSendingOperations> messageSendingOps;

    private static ExecutorService defaultSingletonExecutorService() {
        return new ThreadPoolExecutor(0, 1, 5L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(10, true), (ThreadFactory)new CustomizableThreadFactory("PlatformService-Main-"));
    }

    @Override
    public PlatformService.PlatformState activePlatformState() {
        return PlatformService.PlatformState.values()[this.activeState.get()];
    }

    private void updatePlatformState(PlatformService.PlatformState state) {
        EventAdmin ea;
        PlatformService.PlatformState oldState = PlatformService.PlatformState.values()[this.activeState.getAndSet(state.ordinal())];
        if (oldState == state) {
            return;
        }
        OptionalService<EventAdmin> optEa = this.eventAdmin;
        EventAdmin eventAdmin = ea = optEa != null ? (EventAdmin)optEa.service() : null;
        if (ea == null) {
            return;
        }
        HashMap<String, String> props = new HashMap<String, String>(2);
        props.put("platformState", state.toString());
        props.put("oldPlatformState", oldState.toString());
        Event event = new Event("net/solarnetwork/node/PlatformService/STATE_CHANGED", props);
        ea.postEvent(event);
    }

    @Override
    public PlatformService.PlatformTaskStatus activePlatformTaskStatus() {
        return this.activeSingletonTask.get();
    }

    @Override
    public PlatformService.PlatformTaskInfo activePlatformTaskInfo(Locale locale) {
        PlatformService.PlatformTaskStatus status = this.activePlatformTaskStatus();
        if (status == null) {
            return null;
        }
        return new SimplePlatformTaskInfo(status, locale);
    }

    @Override
    public void subscribeToActivePlatformTaskInfo(Locale locale) {
        PlatformService.PlatformTask<?> task = this.activeSingletonTask.get();
        if (task != null) {
            final Locale loc = locale != null ? locale : Locale.getDefault();
            final String lang = loc != null && loc.getLanguage() != null ? loc.getLanguage() : "en";
            task.registerStatusHandler(new PlatformService.PlatformTaskStatusHandler(){

                @Override
                public void taskStatusUpdated(PlatformService.PlatformTaskStatus status) {
                    SimplePlatformTaskInfo info = new SimplePlatformTaskInfo(status, loc);
                    DefaultPlatformService.this.postMessage("/pub/topic/platform/task", info, Collections.singletonMap("lang", lang), true);
                }
            });
        }
    }

    private void postMessage(String dest, Object body, Map<String, Object> headers, boolean convert) {
        SimpMessageSendingOperations ops;
        SimpMessageSendingOperations simpMessageSendingOperations = ops = this.messageSendingOps != null ? (SimpMessageSendingOperations)this.messageSendingOps.service() : null;
        if (ops == null) {
            return;
        }
        if (convert) {
            Result r = body instanceof Result ? (Result)body : Result.result((Object)body);
            ops.convertAndSend((Object)dest, (Object)r, headers);
        } else {
            GenericMessage msg = new GenericMessage(body, headers);
            ops.send((Object)dest, (Message)msg);
        }
    }

    @Override
    public <T> Future<T> performTaskWithState(final PlatformService.PlatformState state, final PlatformService.PlatformTask<T> task) {
        return this.singletonExecutorService.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                Object v;
                try {
                    if (!DefaultPlatformService.this.activeSingletonTask.compareAndSet(null, task)) {
                        throw new IllegalStateException("Another task is active; cannot start task " + task);
                    }
                    DefaultPlatformService.this.updatePlatformState(state);
                    v = task.call();
                    DefaultPlatformService.this.activeSingletonTask.compareAndSet(task, null);
                }
                catch (Throwable throwable) {
                    DefaultPlatformService.this.activeSingletonTask.compareAndSet(task, null);
                    DefaultPlatformService.this.updatePlatformState(task.isComplete() && task.isRestartRequired() ? PlatformService.PlatformState.Restarting : PlatformService.PlatformState.Normal);
                    throw throwable;
                }
                DefaultPlatformService.this.updatePlatformState(task.isComplete() && task.isRestartRequired() ? PlatformService.PlatformState.Restarting : PlatformService.PlatformState.Normal);
                return v;
            }
        });
    }

    public void setSingletonExecutorService(ExecutorService singletonExecutorService) {
        this.singletonExecutorService = singletonExecutorService;
    }

    public void setEventAdmin(OptionalService<EventAdmin> eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void setMessageSendingOperations(OptionalService<SimpMessageSendingOperations> messageSendingOps) {
        this.messageSendingOps = messageSendingOps;
    }
}

