/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.service;

import java.util.AbstractMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.solarnetwork.service.OptionalService;
import net.solarnetwork.util.StringUtils;

public interface PlaceholderService {
    public String resolvePlaceholders(String var1, Map<String, ?> var2);

    public void registerParameters(Map<String, ?> var1);

    default public <T> void copyPlaceholders(Map<String, T> destination) {
        this.copyPlaceholders(destination, (Predicate)null);
    }

    public <T> void copyPlaceholders(Map<String, T> var1, Predicate<Map.Entry<String, T>> var2);

    default public <T> void copyPlaceholders(Map<String, T> destination, Pattern keyFilter) {
        Predicate<Map.Entry<String, T>> filter = null;
        if (keyFilter != null) {
            filter = e -> keyFilter.matcher((CharSequence)e.getKey()).find();
        }
        this.copyPlaceholders(destination, filter);
    }

    default public void smartCopyPlaceholders(Map<String, Object> destination) {
        this.smartCopyPlaceholders(destination, (Predicate)null);
    }

    default public void smartCopyPlaceholders(Map<String, Object> destination, Pattern keyFilter) {
        Predicate<Map.Entry<String, ?>> filter = null;
        if (keyFilter != null) {
            filter = e -> keyFilter.matcher((CharSequence)e.getKey()).find();
        }
        this.smartCopyPlaceholders(destination, filter);
    }

    default public void smartCopyPlaceholders(Map<String, Object> destination, Predicate<Map.Entry<String, ?>> filter) {
        this.mapPlaceholders(destination, s -> {
            if (filter != null) {
                s = s.filter(filter);
            }
            return s.map(entry -> {
                Number n;
                Object v = entry.getValue();
                if (v != null && !(v instanceof Number) && (n = StringUtils.numberValue((String)v.toString())) != null) {
                    v = n;
                }
                return new AbstractMap.SimpleEntry((String)entry.getKey(), v);
            });
        });
    }

    public <T> void mapPlaceholders(Map<String, T> var1, Function<Stream<Map.Entry<String, ?>>, Stream<Map.Entry<String, T>>> var2);

    public static String resolvePlaceholders(OptionalService<PlaceholderService> service, String s, Map<String, ?> parameters) {
        PlaceholderService ps = (PlaceholderService)OptionalService.service(service);
        return ps != null ? ps.resolvePlaceholders(s, parameters) : s;
    }

    public static <T> void copyPlaceholders(OptionalService<PlaceholderService> service, Map<String, T> destination) {
        PlaceholderService.copyPlaceholders(service, destination, (Predicate)null);
    }

    public static <T> void copyPlaceholders(OptionalService<PlaceholderService> service, Map<String, T> destination, Predicate<Map.Entry<String, T>> filter) {
        if (destination == null) {
            return;
        }
        PlaceholderService ps = (PlaceholderService)OptionalService.service(service);
        if (ps != null) {
            ps.copyPlaceholders(destination, filter);
        }
    }

    public static <T> void copyPlaceholders(OptionalService<PlaceholderService> service, Map<String, T> destination, Pattern keyFilter) {
        if (destination == null) {
            return;
        }
        PlaceholderService ps = (PlaceholderService)OptionalService.service(service);
        if (ps != null) {
            ps.copyPlaceholders(destination, keyFilter);
        }
    }

    public static <T> void mapPlaceholders(OptionalService<PlaceholderService> service, Map<String, T> destination, Function<Stream<Map.Entry<String, ?>>, Stream<Map.Entry<String, T>>> filter) {
        if (destination == null) {
            return;
        }
        PlaceholderService ps = (PlaceholderService)OptionalService.service(service);
        if (ps != null) {
            ps.mapPlaceholders(destination, filter);
        }
    }

    public static void smartCopyPlaceholders(OptionalService<PlaceholderService> service, Map<String, Object> destination) {
        if (destination == null) {
            return;
        }
        PlaceholderService ps = (PlaceholderService)OptionalService.service(service);
        if (ps != null) {
            ps.smartCopyPlaceholders(destination);
        }
    }

    public static void smartCopyPlaceholders(OptionalService<PlaceholderService> service, Map<String, Object> destination, Pattern keyFilter) {
        if (destination == null) {
            return;
        }
        PlaceholderService ps = (PlaceholderService)OptionalService.service(service);
        if (ps != null) {
            ps.smartCopyPlaceholders(destination, keyFilter);
        }
    }

    public static void smartCopyPlaceholders(OptionalService<PlaceholderService> service, Map<String, Object> destination, Predicate<Map.Entry<String, ?>> filter) {
        if (destination == null) {
            return;
        }
        PlaceholderService ps = (PlaceholderService)OptionalService.service(service);
        if (ps != null) {
            ps.smartCopyPlaceholders(destination, filter);
        }
    }
}

