/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.service.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.solarnetwork.domain.datum.MutableDatumSamplesOperations;
import net.solarnetwork.node.service.PlaceholderService;
import net.solarnetwork.node.service.support.ExpressionConfig;
import net.solarnetwork.service.ExpressionService;
import net.solarnetwork.service.Identifiable;
import net.solarnetwork.service.OptionalService;
import net.solarnetwork.service.OptionalServiceCollection;
import net.solarnetwork.service.support.BasicIdentifiable;
import net.solarnetwork.service.support.ExpressionServiceExpression;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.support.BasicTextFieldSettingSpecifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.ExpressionException;

public abstract class BaseIdentifiable
extends BasicIdentifiable
implements Identifiable {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private OptionalService<PlaceholderService> placeholderService;
    private OptionalServiceCollection<ExpressionService> expressionServices;

    public static List<SettingSpecifier> baseIdentifiableSettings(String prefix) {
        return BaseIdentifiable.baseIdentifiableSettings(prefix, "", "");
    }

    public static List<SettingSpecifier> baseIdentifiableSettings(String prefix, String defaultUid, String defaultGroupUid) {
        if (prefix == null) {
            prefix = "";
        }
        ArrayList<SettingSpecifier> results = new ArrayList<SettingSpecifier>(8);
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier(prefix + "uid", defaultUid));
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier(prefix + "groupUid", defaultGroupUid));
        return results;
    }

    protected String resolvePlaceholders(String s) {
        return this.resolvePlaceholders(s, null);
    }

    protected String resolvePlaceholders(String s, Map<String, ?> parameters) {
        return PlaceholderService.resolvePlaceholders(this.placeholderService, s, parameters);
    }

    protected void populateExpressionDatumProperties(MutableDatumSamplesOperations d, ExpressionConfig[] expressionConfs, Object root) {
        Iterable services = OptionalServiceCollection.services(this.expressionServices);
        if (services == null || expressionConfs == null || expressionConfs.length < 1 || root == null) {
            return;
        }
        for (ExpressionConfig config : expressionConfs) {
            ExpressionServiceExpression expr;
            if (config.getName() == null || config.getName().isEmpty() || config.getExpression() == null || config.getExpression().isEmpty()) continue;
            try {
                expr = config.getExpression(services);
            }
            catch (ExpressionException e) {
                this.log.warn("Error parsing property [{}] expression `{}`: {}", new Object[]{config.getName(), config.getExpression(), e.getMessage()});
                return;
            }
            Object propValue = null;
            if (expr != null) {
                try {
                    propValue = expr.getService().evaluateExpression(expr.getExpression(), null, root, null, Object.class);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Service [{}] evaluated datum property [{}] expression `{}` \u2192 {}\n\nExpression root: {}", new Object[]{this.getUid(), config.getName(), config.getExpression(), propValue, root});
                    } else if (this.log.isDebugEnabled()) {
                        this.log.debug("Service [{}] evaluated datum property [{}] expression `{}` \u2192 {}", new Object[]{this.getUid(), config.getName(), config.getExpression(), propValue});
                    }
                }
                catch (ExpressionException e) {
                    this.log.warn("Error evaluating service [{}] datum property [{}] expression `{}`: {}\n\nExpression root: {}", new Object[]{this.getUid(), config.getName(), config.getExpression(), e.getMessage(), root});
                }
            }
            if (propValue == null) continue;
            d.putSampleValue(config.getDatumPropertyType(), config.getName(), propValue);
        }
    }

    public OptionalService<PlaceholderService> getPlaceholderService() {
        return this.placeholderService;
    }

    public void setPlaceholderService(OptionalService<PlaceholderService> placeholderService) {
        this.placeholderService = placeholderService;
    }

    public OptionalServiceCollection<ExpressionService> getExpressionServices() {
        return this.expressionServices;
    }

    public void setExpressionServices(OptionalServiceCollection<ExpressionService> expressionServices) {
        this.expressionServices = expressionServices;
    }
}

