/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.service.support;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import net.solarnetwork.node.service.PlatformPackageService;
import net.solarnetwork.node.service.support.BasicPlatformPackageResult;
import net.solarnetwork.service.OptionalService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.AsyncTaskExecutor;

public abstract class BasePlatformPackageService
implements PlatformPackageService {
    private OptionalService<AsyncTaskExecutor> taskExecutor;
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    protected <T> Future<PlatformPackageService.PlatformPackageResult<T>> performPackageResultTask(Callable<PlatformPackageService.PlatformPackageResult<T>> task, T context) {
        AsyncTaskExecutor executor = this.taskExecutor();
        if (executor != null) {
            return executor.submit(task);
        }
        CompletableFuture<PlatformPackageService.PlatformPackageResult<PlatformPackageService.PlatformPackageResult<T>>> future = new CompletableFuture<PlatformPackageService.PlatformPackageResult<PlatformPackageService.PlatformPackageResult<T>>>();
        try {
            future.complete(task.call());
        }
        catch (Throwable t) {
            future.complete(new BasicPlatformPackageResult<T>(false, t.getMessage(), t, null, context));
        }
        return future;
    }

    protected <T> Future<T> performTask(Callable<T> task) {
        AsyncTaskExecutor executor = this.taskExecutor();
        if (executor != null) {
            return executor.submit(task);
        }
        CompletableFuture<T> future = new CompletableFuture<T>();
        try {
            future.complete(task.call());
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    protected AsyncTaskExecutor taskExecutor() {
        OptionalService<AsyncTaskExecutor> os = this.getTaskExecutor();
        return os != null ? (AsyncTaskExecutor)os.service() : null;
    }

    public OptionalService<AsyncTaskExecutor> getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(OptionalService<AsyncTaskExecutor> taskExecutor) {
        this.taskExecutor = taskExecutor;
    }
}

