/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.service.support;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.solarnetwork.node.Constants;
import net.solarnetwork.node.service.PlatformPackageService;
import net.solarnetwork.node.service.support.BasePlatformPackageService;
import net.solarnetwork.node.service.support.BasicPlatformPackage;
import net.solarnetwork.node.service.support.BasicPlatformPackageResult;
import net.solarnetwork.service.ProgressListener;
import net.solarnetwork.util.StringUtils;

public abstract class BaseSolarPkgPlatformPackageService
extends BasePlatformPackageService {
    public static final String DEFAULT_COMMAND = Constants.solarNodeHome() + "/bin/solarpkg";
    public static final long DEFAULT_PACKAGE_ACTION_TIMEOUT_SECS = TimeUnit.MINUTES.toSeconds(5L);
    private long packageActionTimeoutSecs = DEFAULT_PACKAGE_ACTION_TIMEOUT_SECS;
    private String command = DEFAULT_COMMAND;

    protected List<String> pkgCommand(Action action, String ... args) {
        ArrayList<String> result = new ArrayList<String>(2 + (args != null ? args.length : 0));
        result.add(this.getCommand());
        result.add(action.getCommand());
        if (args != null) {
            for (String arg : args) {
                if (arg == null) continue;
                result.add(arg);
            }
        }
        return result;
    }

    protected <T> PlatformPackageService.PlatformPackageResult<T> executePackageCommand(List<String> cmd, T context) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Package command: {}", (Object)StringUtils.delimitedStringFromCollection(cmd, (String)" "));
        }
        List<String> installed = this.executeCommand(cmd);
        ArrayList<Path> extractedPaths = new ArrayList<Path>();
        for (String p : installed) {
            Path path = FileSystems.getDefault().getPath(p, new String[0]).toAbsolutePath().normalize();
            extractedPaths.add(path);
        }
        return new BasicPlatformPackageResult<T>(true, null, null, extractedPaths, context);
    }

    protected List<String> executeCommand(List<String> cmd) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Package command: {}", (Object)StringUtils.delimitedStringFromCollection(cmd, (String)" "));
        }
        ArrayList<String> result = new ArrayList<String>();
        ProcessBuilder pb = new ProcessBuilder(cmd);
        Path devNull = Paths.get("/dev/null", new String[0]);
        if (Files.exists(devNull, new LinkOption[0])) {
            pb.redirectInput(devNull.toFile());
        }
        Process pr = pb.start();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(pr.getInputStream()));
             BufferedReader err = new BufferedReader(new InputStreamReader(pr.getErrorStream()));){
            String line = null;
            while ((line = in.readLine()) != null) {
                result.add(line);
                this.log.trace("Package command output: {}", (Object)line);
            }
            if (!pr.waitFor(this.packageActionTimeoutSecs, TimeUnit.SECONDS)) {
                throw new IOException("Timeout waiting for package command to complete.");
            }
            StringBuilder errMsg = new StringBuilder();
            while ((line = err.readLine()) != null) {
                if (errMsg.length() > 0) {
                    errMsg.append("\n");
                }
                errMsg.append(line);
            }
            if (errMsg.length() > 0) {
                this.log.warn("Package command issued warnings: {}", (Object)errMsg);
            }
        }
        if (pr.exitValue() != 0) {
            String output = StringUtils.delimitedStringFromCollection(result, (String)"\n");
            this.log.error("Package command returned non-zero exit code {}: {}", (Object)pr.exitValue(), (Object)output);
            throw new IOException("Package command returned non-zero exit code " + pr.exitValue() + ": " + output);
        }
        return result;
    }

    @Override
    public <T> Future<PlatformPackageService.PlatformPackageResult<T>> installPackage(final Path archive, Path baseDirectory, ProgressListener<T> progressListener, final T context) {
        Callable task = new Callable<PlatformPackageService.PlatformPackageResult<T>>(){

            @Override
            public PlatformPackageService.PlatformPackageResult<T> call() throws Exception {
                BaseSolarPkgPlatformPackageService.this.log.info("Installing package archive {}", (Object)archive);
                List<String> cmd = BaseSolarPkgPlatformPackageService.this.pkgCommand(Action.Install, archive.toAbsolutePath().toString());
                return BaseSolarPkgPlatformPackageService.this.executePackageCommand(cmd, context);
            }
        };
        return this.performPackageResultTask(task, context);
    }

    @Override
    public Future<Iterable<PlatformPackageService.PlatformPackage>> listNamedPackages(final String nameFilter, final Boolean installedFilter) {
        Callable<Iterable<PlatformPackageService.PlatformPackage>> task = new Callable<Iterable<PlatformPackageService.PlatformPackage>>(){

            @Override
            public Iterable<PlatformPackageService.PlatformPackage> call() throws Exception {
                Action action = installedFilter == null ? Action.List : (installedFilter == true ? Action.ListInstalled : Action.ListAvailable);
                List<String> cmd = BaseSolarPkgPlatformPackageService.this.pkgCommand(action, nameFilter);
                List<String> csv = BaseSolarPkgPlatformPackageService.this.executeCommand(cmd);
                if (csv == null || csv.isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList<PlatformPackageService.PlatformPackage> results = new ArrayList<PlatformPackageService.PlatformPackage>(csv.size());
                for (String row : csv) {
                    String[] cols = org.springframework.util.StringUtils.commaDelimitedListToStringArray((String)row);
                    if (cols == null || cols.length <= 2) continue;
                    results.add(new BasicPlatformPackage(cols[0], cols[1], StringUtils.parseBoolean((String)cols[2])));
                }
                return results;
            }
        };
        return this.performTask(task);
    }

    @Override
    public <T> Future<PlatformPackageService.PlatformPackageResult<T>> installNamedPackage(final String name, final String version, Path baseDirectory, ProgressListener<T> progressListener, final T context) {
        Callable task = new Callable<PlatformPackageService.PlatformPackageResult<T>>(){

            @Override
            public PlatformPackageService.PlatformPackageResult<T> call() throws Exception {
                BaseSolarPkgPlatformPackageService.this.log.info("Installing package {} version {}", (Object)name, (Object)version);
                List<String> cmd = BaseSolarPkgPlatformPackageService.this.pkgCommand(Action.Install, name, version);
                return BaseSolarPkgPlatformPackageService.this.executePackageCommand(cmd, context);
            }
        };
        return this.performPackageResultTask(task, context);
    }

    @Override
    public <T> Future<PlatformPackageService.PlatformPackageResult<T>> removeNamedPackage(final String name, ProgressListener<T> progressListener, final T context) {
        Callable task = new Callable<PlatformPackageService.PlatformPackageResult<T>>(){

            @Override
            public PlatformPackageService.PlatformPackageResult<T> call() throws Exception {
                BaseSolarPkgPlatformPackageService.this.log.info("Removing package {} version {}", (Object)name);
                List<String> cmd = BaseSolarPkgPlatformPackageService.this.pkgCommand(Action.Remove, name);
                return BaseSolarPkgPlatformPackageService.this.executePackageCommand(cmd, context);
            }
        };
        return this.performPackageResultTask(task, context);
    }

    @Override
    public <T> Future<PlatformPackageService.PlatformPackageResult<T>> upgradeNamedPackages(ProgressListener<T> progressListener, final T context) {
        Callable task = new Callable<PlatformPackageService.PlatformPackageResult<T>>(){

            @Override
            public PlatformPackageService.PlatformPackageResult<T> call() throws Exception {
                BaseSolarPkgPlatformPackageService.this.log.info("Upgrading packages");
                List<String> cmd = BaseSolarPkgPlatformPackageService.this.pkgCommand(Action.Upgrade, new String[0]);
                return BaseSolarPkgPlatformPackageService.this.executePackageCommand(cmd, context);
            }
        };
        return this.performPackageResultTask(task, context);
    }

    @Override
    public Future<Boolean> refreshNamedPackages() {
        Callable<Boolean> task = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                List<String> cmd = BaseSolarPkgPlatformPackageService.this.pkgCommand(Action.Refresh, new String[0]);
                BaseSolarPkgPlatformPackageService.this.executeCommand(cmd);
                return true;
            }
        };
        return this.performTask(task);
    }

    @Override
    public Future<Boolean> cleanup() {
        Callable<Boolean> task = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                List<String> cmd = BaseSolarPkgPlatformPackageService.this.pkgCommand(Action.Clean, new String[0]);
                BaseSolarPkgPlatformPackageService.this.executeCommand(cmd);
                return true;
            }
        };
        return this.performTask(task);
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public long getPackageActionTimeoutSecs() {
        return this.packageActionTimeoutSecs;
    }

    public void setPackageActionTimeoutSecs(long packageActionTimeoutSecs) {
        this.packageActionTimeoutSecs = packageActionTimeoutSecs;
    }

    public static enum Action {
        Clean("clean"),
        Install("install"),
        IsInstalled("is-installed"),
        List("list"),
        ListAvailable("list-available"),
        ListInstalled("list-installed"),
        Refresh("refresh"),
        Remove("remove"),
        Upgrade("upgrade");

        private final String command;

        private Action(String cmd) {
            this.command = cmd;
        }

        public String getCommand() {
            return this.command;
        }

        public static Action forCommand(String cmd) {
            for (Action a : Action.values()) {
                if (!a.command.equalsIgnoreCase(cmd)) continue;
                return a;
            }
            throw new IllegalArgumentException("Command [" + cmd + "] not supported");
        }
    }
}

