/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.service.support;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import net.solarnetwork.domain.datum.DatumSamplePropertyConfig;
import net.solarnetwork.domain.datum.DatumSamplesType;
import net.solarnetwork.node.settings.SettingValueBean;
import net.solarnetwork.service.ExpressionService;
import net.solarnetwork.service.support.ExpressionServiceExpression;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.support.BasicMultiValueSettingSpecifier;
import net.solarnetwork.settings.support.BasicTextAreaSettingSpecifier;
import net.solarnetwork.settings.support.BasicTextFieldSettingSpecifier;
import org.springframework.expression.Expression;

public class ExpressionConfig
extends DatumSamplePropertyConfig<String> {
    private String expressionServiceId;
    private Expression cachedExpression;

    public ExpressionConfig() {
        super(null, DatumSamplesType.Instantaneous, null);
    }

    public ExpressionConfig(String name, DatumSamplesType propertyType, String expression, String expressionServiceId) {
        super(name, propertyType, (Object)expression);
        this.expressionServiceId = expressionServiceId;
    }

    public static List<SettingSpecifier> settings(Class<?> clazz, String prefix, Iterable<ExpressionService> expressionServices) {
        ExpressionConfig defaults = new ExpressionConfig();
        ArrayList<SettingSpecifier> results = new ArrayList<SettingSpecifier>(3);
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier(prefix + "name", ""));
        BasicMultiValueSettingSpecifier propTypeSpec = new BasicMultiValueSettingSpecifier(prefix + "datumPropertyTypeKey", defaults.getDatumPropertyTypeKey());
        LinkedHashMap<String, String> propTypeTitles = new LinkedHashMap<String, String>(3);
        for (DatumSamplesType e : DatumSamplesType.values()) {
            propTypeTitles.put(Character.toString(e.toKey()), e.toString());
        }
        propTypeSpec.setValueTitles(propTypeTitles);
        results.add((SettingSpecifier)propTypeSpec);
        if (expressionServices != null) {
            BasicMultiValueSettingSpecifier expressionServiceId = new BasicMultiValueSettingSpecifier(prefix + "expressionServiceId", "");
            LinkedHashMap<String, String> exprServiceTitles = new LinkedHashMap<String, String>();
            exprServiceTitles.put("", "");
            for (ExpressionService service : expressionServices) {
                exprServiceTitles.put(service.getUid(), service.getDisplayName());
            }
            expressionServiceId.setValueTitles(exprServiceTitles);
            if (!exprServiceTitles.isEmpty()) {
                BasicTextAreaSettingSpecifier exprSetting = new BasicTextAreaSettingSpecifier(prefix + "expression", "", true);
                exprSetting.setDescriptionArguments(new Object[]{ExpressionService.getGeneralExpressionReferenceLink(), ExpressionConfig.expressionReferenceLink(clazz)});
                results.add((SettingSpecifier)exprSetting);
                results.add((SettingSpecifier)expressionServiceId);
            }
        }
        return results;
    }

    public List<SettingValueBean> toSettingValues(String providerId, String instanceId, String prefix) {
        ArrayList<SettingValueBean> settings = new ArrayList<SettingValueBean>(16);
        settings.add(new SettingValueBean(providerId, instanceId, prefix + "name", this.getName()));
        settings.add(new SettingValueBean(providerId, instanceId, prefix + "datumPropertyTypeKey", this.getDatumPropertyTypeKey()));
        settings.add(new SettingValueBean(providerId, instanceId, prefix + "expressionServiceId", this.getExpressionServiceId()));
        settings.add(new SettingValueBean(providerId, instanceId, prefix + "expression", this.getExpression()));
        return settings;
    }

    public static URI expressionReferenceLink(Class<?> clazz) {
        String result = null;
        Properties props = new Properties();
        try (InputStream in2 = clazz.getResourceAsStream("ExpressionConfig.properties");){
            if (in2 != null) {
                props.load(in2);
                if (props.containsKey("expressions.url")) {
                    result = props.getProperty("expressions.url");
                }
            }
        }
        catch (IOException in2) {
            // empty catch block
        }
        URI uri = null;
        if (result != null) {
            try {
                uri = new URI(result);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        } else {
            uri = ExpressionService.getGeneralExpressionReferenceLink();
        }
        return uri;
    }

    public synchronized ExpressionServiceExpression getExpression(Iterable<ExpressionService> services) {
        for (ExpressionService service : services) {
            if (service == null || !service.getUid().equalsIgnoreCase(this.expressionServiceId)) continue;
            Expression expr = this.cachedExpression;
            if (expr == null && (expr = service.parseExpression(this.getExpression())) != null) {
                this.cachedExpression = expr;
            }
            if (expr == null) continue;
            return new ExpressionServiceExpression(service, expr);
        }
        return null;
    }

    public String getName() {
        return this.getPropertyKey();
    }

    public void setName(String name) {
        this.setPropertyKey(name);
    }

    public synchronized String getExpression() {
        return (String)this.getConfig();
    }

    public synchronized void setExpression(String expression) {
        this.setConfig(expression);
        this.cachedExpression = null;
    }

    public String getExpressionServiceId() {
        return this.expressionServiceId;
    }

    public synchronized void setExpressionServiceId(String expressionServiceId) {
        this.expressionServiceId = expressionServiceId;
        this.cachedExpression = null;
    }

    public DatumSamplesType getDatumPropertyType() {
        return this.getPropertyType();
    }

    public void setDatumPropertyType(DatumSamplesType datumPropertyType) {
        if (datumPropertyType == null) {
            return;
        }
        this.setPropertyType(datumPropertyType);
    }

    public String getDatumPropertyTypeKey() {
        DatumSamplesType type = this.getDatumPropertyType();
        if (type == null) {
            type = DatumSamplesType.Instantaneous;
        }
        return Character.toString(type.toKey());
    }

    public void setDatumPropertyTypeKey(String key) {
        DatumSamplesType type = null;
        if (key != null && key.length() > 0) {
            try {
                type = DatumSamplesType.valueOf((char)key.charAt(0));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (type == null) {
            type = DatumSamplesType.Instantaneous;
        }
        this.setDatumPropertyType(type);
    }
}

