/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.service.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.solarnetwork.domain.datum.DatumId;
import net.solarnetwork.domain.datum.GeneralLocationSourceMetadata;
import net.solarnetwork.domain.datum.ObjectDatumKind;
import net.solarnetwork.node.domain.datum.DatumLocation;
import net.solarnetwork.node.domain.datum.NodeDatum;
import net.solarnetwork.node.domain.datum.SimpleDatumLocation;
import net.solarnetwork.node.service.DatumDataSource;
import net.solarnetwork.node.service.LocationService;
import net.solarnetwork.node.service.MultiDatumDataSource;
import net.solarnetwork.node.settings.LocationLookupSettingSpecifier;
import net.solarnetwork.node.settings.support.BasicLocationLookupSettingSpecifier;
import net.solarnetwork.service.OptionalService;
import net.solarnetwork.settings.KeyedSettingSpecifier;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.SettingSpecifierProvider;
import net.solarnetwork.support.PrefixedMessageSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.support.ResourceBundleMessageSource;

public class LocationDatumDataSource
implements DatumDataSource,
MultiDatumDataSource,
SettingSpecifierProvider {
    public static final String DEFAULT_LOCATION_ID_PROP_NAME = "locationId";
    public static final String DEFAULT_SOURCE_ID_PROP_NAME = "locationSourceId";
    public static final String PRICE_LOCATION_MESSAGE_BUNDLE = "net.solarnetwork.node.service.support.PriceLocationDatumDataSource";
    private DatumDataSource delegate;
    private OptionalService<LocationService> locationService;
    private String locationType = "price";
    private String locationIdPropertyName = "locationId";
    private String sourceIdPropertyName = "locationSourceId";
    private boolean requireLocationService = false;
    private String messageBundleBasename = "net.solarnetwork.node.service.support.PriceLocationDatumDataSource";
    private Long locationId = null;
    private String sourceId = null;
    private Set<String> datumClassNameIgnore;
    private DatumLocation location = null;
    private MessageSource messageSource;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Class<? extends NodeDatum> getDatumType() {
        return this.delegate.getDatumType();
    }

    @Override
    public Class<? extends NodeDatum> getMultiDatumType() {
        if (this.delegate instanceof MultiDatumDataSource) {
            return ((MultiDatumDataSource)((Object)this.delegate)).getMultiDatumType();
        }
        return this.delegate.getDatumType();
    }

    @Override
    public Collection<NodeDatum> readMultipleDatum() {
        Collection<NodeDatum> datumList = null;
        if (this.delegate instanceof MultiDatumDataSource) {
            datumList = ((MultiDatumDataSource)((Object)this.delegate)).readMultipleDatum();
        } else {
            datumList = new ArrayList<NodeDatum>(1);
            NodeDatum datum = this.delegate.readCurrentDatum();
            if (datum != null) {
                datumList.add(datum);
            }
        }
        ArrayList<NodeDatum> result = new ArrayList<NodeDatum>();
        if (datumList != null && this.locationId != null) {
            for (NodeDatum datum : datumList) {
                NodeDatum d = this.populateLocation(datum);
                if (d == null) continue;
                result.add(d);
            }
        } else if (datumList != null && !datumList.isEmpty() && this.locationId == null && this.requireLocationService) {
            this.log.warn("Location required but not available, discarding datum: {}", datumList);
        }
        return result;
    }

    @Override
    public NodeDatum readCurrentDatum() {
        NodeDatum datum = this.delegate.readCurrentDatum();
        if (datum != null && this.locationId != null) {
            datum = this.populateLocation(datum);
        } else if (datum != null && this.locationId == null && this.requireLocationService) {
            this.log.warn("LocationService required but not available, discarding datum: {}", (Object)datum);
            datum = null;
        }
        return datum;
    }

    private NodeDatum populateLocation(NodeDatum datum) {
        if (this.locationId != null && this.sourceId != null && !this.shouldIgnoreDatum(datum)) {
            this.log.debug("Augmenting datum {} with locaiton ID {} ({})", new Object[]{datum, this.locationId, this.sourceId});
            return datum.copyWithId(new DatumId(ObjectDatumKind.Location, this.locationId, this.sourceId, datum.getTimestamp()));
        }
        return datum;
    }

    private boolean shouldIgnoreDatum(NodeDatum datum) {
        return datum == null || this.datumClassNameIgnore != null && this.datumClassNameIgnore.contains(datum.getClass().getName());
    }

    public String toString() {
        return this.delegate != null ? this.delegate.toString() + "[LocationDatumDataSource proxy]" : "LocationDatumDataSource";
    }

    public String getUid() {
        return this.delegate.getUid();
    }

    public String getGroupUid() {
        return this.delegate.getGroupUid();
    }

    public String getSettingUid() {
        if (this.delegate instanceof SettingSpecifierProvider) {
            return ((SettingSpecifierProvider)this.delegate).getSettingUid();
        }
        return this.getClass().getName();
    }

    public String getDisplayName() {
        if (this.delegate instanceof SettingSpecifierProvider) {
            return ((SettingSpecifierProvider)this.delegate).getDisplayName();
        }
        return null;
    }

    public synchronized MessageSource getMessageSource() {
        if (this.messageSource == null) {
            MessageSource other = null;
            if (this.delegate instanceof SettingSpecifierProvider) {
                other = ((SettingSpecifierProvider)this.delegate).getMessageSource();
            }
            PrefixedMessageSource delegateSource = null;
            if (other != null) {
                delegateSource = new PrefixedMessageSource();
                delegateSource.setDelegate(other);
                delegateSource.setPrefix("delegate.");
            }
            ResourceBundleMessageSource proxySource = new ResourceBundleMessageSource();
            proxySource.setBundleClassLoader(this.getClass().getClassLoader());
            proxySource.setBasename(this.messageBundleBasename);
            if (delegateSource != null) {
                proxySource.setParentMessageSource((MessageSource)delegateSource);
            }
            this.messageSource = proxySource;
        }
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public List<SettingSpecifier> getSettingSpecifiers() {
        List delegateResult;
        ArrayList<SettingSpecifier> result = new ArrayList<SettingSpecifier>();
        result.add((SettingSpecifier)this.getLocationSettingSpecifier());
        if (this.delegate instanceof SettingSpecifierProvider && (delegateResult = ((SettingSpecifierProvider)this.delegate).getSettingSpecifiers()) != null) {
            for (SettingSpecifier spec : delegateResult) {
                if (spec instanceof KeyedSettingSpecifier) {
                    KeyedSettingSpecifier keyedSpec = (KeyedSettingSpecifier)spec;
                    result.add(keyedSpec.mappedTo("delegate."));
                    continue;
                }
                result.add(spec);
            }
        }
        return result;
    }

    private LocationLookupSettingSpecifier getLocationSettingSpecifier() {
        LocationService service;
        if (this.location == null && this.locationService != null && this.locationId != null && this.sourceId != null && (service = (LocationService)this.locationService.service()) != null) {
            try {
                GeneralLocationSourceMetadata meta = service.getLocationMetadata(this.locationId, this.sourceId);
                SimpleDatumLocation loc = new SimpleDatumLocation();
                loc.setLocationId(this.locationId);
                loc.setSourceId(this.sourceId);
                loc.setSourceMetadata(meta);
                this.location = loc;
            }
            catch (Exception e) {
                Throwable root = e;
                while (root.getCause() != null) {
                    root = root.getCause();
                }
                this.log.error("Error looking up location {} for source [{}]: {}", new Object[]{this.locationId, this.sourceId, root.toString()});
            }
        }
        return new BasicLocationLookupSettingSpecifier("locationKey", this.locationType, this.location);
    }

    public DatumDataSource getDelegate() {
        return this.delegate;
    }

    public void setDelegate(DatumDataSource delegate) {
        this.delegate = delegate;
    }

    public OptionalService<LocationService> getLocationService() {
        return this.locationService;
    }

    public void setLocationService(OptionalService<LocationService> locationService) {
        this.locationService = locationService;
    }

    public String getLocationIdPropertyName() {
        return this.locationIdPropertyName;
    }

    public void setLocationIdPropertyName(String locationIdPropertyName) {
        this.locationIdPropertyName = locationIdPropertyName;
    }

    public boolean isRequireLocationService() {
        return this.requireLocationService;
    }

    public void setRequireLocationService(boolean requireLocationService) {
        this.requireLocationService = requireLocationService;
    }

    public String getLocationType() {
        return this.locationType;
    }

    public void setLocationType(String locationType) {
        this.locationType = locationType;
    }

    public String getMessageBundleBasename() {
        return this.messageBundleBasename;
    }

    public void setMessageBundleBasename(String messageBundleBaseName) {
        this.messageBundleBasename = messageBundleBaseName;
    }

    public String getLocationKey() {
        StringBuilder buf = new StringBuilder();
        Long locId = this.getLocationId();
        String sourceId = this.getSourceId();
        if (locId == null && (sourceId == null || sourceId.isEmpty())) {
            return null;
        }
        if (locId != null) {
            buf.append(locId.toString());
        }
        buf.append(":");
        buf.append(sourceId);
        return buf.toString();
    }

    public void setLocationKey(String key) {
        int idx;
        Long newLocationId = null;
        String newSourceId = null;
        if (key != null && (idx = key.indexOf(58)) > 0 && idx + 1 < key.length()) {
            newLocationId = Long.valueOf(key.substring(0, idx));
            newSourceId = key.substring(idx + 1);
        }
        this.setLocationId(newLocationId);
        this.setSourceId(newSourceId);
    }

    public Long getLocationId() {
        return this.locationId;
    }

    public void setLocationId(Long locationId) {
        if (this.location != null && locationId != null && !locationId.equals(this.location.getLocationId())) {
            this.location = null;
        }
        this.locationId = locationId;
    }

    public DatumLocation getLocation() {
        return this.location;
    }

    public Set<String> getDatumClassNameIgnore() {
        return this.datumClassNameIgnore;
    }

    public void setDatumClassNameIgnore(Set<String> datumClassNameIgnore) {
        this.datumClassNameIgnore = datumClassNameIgnore;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        if (this.location != null && sourceId != null && !sourceId.equals(this.location.getSourceId())) {
            this.location = null;
        }
        this.sourceId = sourceId;
    }

    public String getSourceIdPropertyName() {
        return this.sourceIdPropertyName;
    }

    public void setSourceIdPropertyName(String sourceIdPropertyName) {
        this.sourceIdPropertyName = sourceIdPropertyName;
    }
}

