/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.service.support;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.solarnetwork.domain.datum.GeneralDatumMetadata;
import net.solarnetwork.node.domain.NodeAppConfiguration;
import net.solarnetwork.node.service.MetadataService;
import net.solarnetwork.node.service.support.JsonHttpClientSupport;
import net.solarnetwork.node.setup.SetupService;
import net.solarnetwork.security.Snws2AuthorizationBuilder;
import net.solarnetwork.service.OptionalService;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.SettingSpecifierProvider;
import net.solarnetwork.settings.SettingsChangeObserver;
import net.solarnetwork.settings.support.BasicTextFieldSettingSpecifier;
import net.solarnetwork.settings.support.BasicTitleSettingSpecifier;
import net.solarnetwork.util.CachedResult;
import org.springframework.context.MessageSource;

public class UserMetadataService
extends JsonHttpClientSupport
implements MetadataService,
SettingSpecifierProvider,
SettingsChangeObserver {
    public static final String USER_METADATA_PATH = "/api/v1/sec/users/meta";
    public static final int DEFAULT_CACHE_SECONDS = 3600;
    private final OptionalService<SetupService> setupService;
    private int cacheSeconds = 3600;
    private String token = null;
    private String tokenSecret = null;
    private CachedResult<GeneralDatumMetadata> cachedMetadata;

    public UserMetadataService(OptionalService<SetupService> setupService) {
        this.setupService = setupService;
    }

    public synchronized void configurationChanged(Map<String, Object> properties) {
        this.cachedMetadata = null;
    }

    private String solarQueryUrl() {
        SetupService s = (SetupService)OptionalService.service(this.setupService);
        NodeAppConfiguration cfg = s != null ? s.getAppConfiguration() : null;
        Map<String, String> urls = cfg != null ? cfg.getNetworkServiceUrls() : null;
        return urls != null ? urls.get("solarquery") : null;
    }

    @Override
    public synchronized GeneralDatumMetadata getAllMetadata() {
        if (this.cachedMetadata != null && this.cachedMetadata.isValid()) {
            return (GeneralDatumMetadata)this.cachedMetadata.getResult();
        }
        String solarQueryUrl = this.solarQueryUrl();
        String token = this.token;
        String secret = this.tokenSecret;
        if (solarQueryUrl == null || solarQueryUrl.isEmpty()) {
            return null;
        }
        String url = solarQueryUrl + USER_METADATA_PATH;
        try {
            InputStream in = this.jsonGET(url, conn -> {
                if (token != null && !token.isEmpty() && secret != null && !secret.isEmpty()) {
                    Instant now = Instant.now();
                    Snws2AuthorizationBuilder auth = (Snws2AuthorizationBuilder)new Snws2AuthorizationBuilder(token).saveSigningKey(secret);
                    auth.saveSigningKey(secret);
                    this.setupTokenAuthorization((URLConnection)conn, auth, now, null);
                }
            });
            GeneralDatumMetadata meta = this.extractResponseData(in, GeneralDatumMetadata.class);
            if (this.cacheSeconds > 0) {
                this.cachedMetadata = new CachedResult((Object)meta, (long)this.cacheSeconds, TimeUnit.SECONDS);
            }
            return meta;
        }
        catch (IOException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("IOException querying for user metadata at {}: {}", (Object)url, (Object)e.toString());
            } else {
                this.log.warn("Unable to get user metadata: {}", (Object)e.getMessage());
            }
            return null;
        }
    }

    public String getSettingUid() {
        return "net.solarnetwork.node.metadata.user";
    }

    public List<SettingSpecifier> getSettingSpecifiers() {
        this.getAllMetadata();
        List<SettingSpecifier> result = UserMetadataService.baseIdentifiableSettings("");
        result.add(0, (SettingSpecifier)new BasicTitleSettingSpecifier("status", this.getStatusMessage(), true));
        result.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("cacheSeconds", String.valueOf(3600)));
        result.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("token", null));
        result.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("tokenSecret", null, true));
        return result;
    }

    private String getStatusMessage() {
        CachedResult<GeneralDatumMetadata> cached = this.cachedMetadata;
        MessageSource msgSource = this.getMessageSource();
        if (cached == null) {
            return msgSource.getMessage("status.noneCached", null, Locale.getDefault());
        }
        GeneralDatumMetadata meta = (GeneralDatumMetadata)cached.getResult();
        if (meta == null) {
            return msgSource.getMessage("status.none", new Object[]{new Date(cached.getCreated()), new Date(cached.getExpires())}, Locale.getDefault());
        }
        Map info = meta.getInfo();
        Map propInfo = meta.getPropertyInfo();
        return msgSource.getMessage("status.msg", new Object[]{new Date(cached.getCreated()), new Date(cached.getExpires()), info != null ? info.size() : 0, propInfo != null ? propInfo.size() : 0}, Locale.getDefault());
    }

    public void setCacheSeconds(int cacheSeconds) {
        this.cacheSeconds = cacheSeconds;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setTokenSecret(String tokenSecret) {
        this.tokenSecret = tokenSecret;
    }
}

