/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.setup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.solarnetwork.node.setup.ResourceSetupResource;
import net.solarnetwork.node.setup.SetupResource;
import net.solarnetwork.node.setup.SetupResourceProvider;
import net.solarnetwork.node.setup.SetupResourceScope;
import net.solarnetwork.node.setup.SetupResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.StringUtils;

public class PatternMatchingSetupResourceProvider
implements SetupResourceProvider,
ApplicationContextAware {
    public static final String UNKNOWN_CONTENT_TYPE = "application/octet-stream";
    private Locale defaultLocale = Locale.US;
    private Set<String> consumerTypes = SetupResource.WEB_CONSUMER_TYPES;
    private Set<String> roles = SetupResource.USER_ROLES;
    private SetupResourceScope scope = SetupResourceScope.Default;
    private String[] basenames;
    private ResourcePatternResolver resourcePatternResolver;
    private int cacheSeconds = 86400;
    private Map<String, String> fileExtensionContentTypeMapping = SetupResourceUtils.DEFAULT_FILENAME_EXTENSION_CONTENT_TYPES;
    private static final Logger LOG = LoggerFactory.getLogger(PatternMatchingSetupResourceProvider.class);

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.resourcePatternResolver == null) {
            this.resourcePatternResolver = applicationContext;
        }
    }

    @Override
    public SetupResource getSetupResource(String resourceUID, Locale locale) {
        int bestScore = -1;
        SetupResource bestMatch = null;
        for (String basename : this.basenames) {
            List<SetupResource> resources = this.resolveSetupResourcesForBasename(basename);
            for (SetupResource rsrc : resources) {
                if (!resourceUID.equals(rsrc.getResourceUID())) continue;
                int score = SetupResourceUtils.localeScore(rsrc, locale, this.defaultLocale);
                if (score == Integer.MAX_VALUE) {
                    return rsrc;
                }
                if (bestMatch != null && score <= bestScore) continue;
                bestScore = score;
                bestMatch = rsrc;
            }
        }
        return bestMatch;
    }

    @Override
    public Collection<SetupResource> getSetupResourcesForConsumer(String consumerType, Locale locale) {
        if (!consumerType.equals(consumerType)) {
            return Collections.emptyList();
        }
        ArrayList<SetupResource> results = new ArrayList<SetupResource>(this.basenames.length);
        for (String basename : this.basenames) {
            HashMap<String, SetupResource> bestMatches = new HashMap<String, SetupResource>();
            List<SetupResource> resources = this.resolveSetupResourcesForBasename(basename);
            for (SetupResource rsrc : resources) {
                SetupResource currMatch;
                Set<String> supported = rsrc.getSupportedConsumerTypes();
                if (supported != null && !supported.contains(consumerType) || SetupResourceUtils.localeScore(currMatch = (SetupResource)bestMatches.get(rsrc.getResourceUID()), locale, this.defaultLocale) >= SetupResourceUtils.localeScore(rsrc, locale, this.defaultLocale)) continue;
                bestMatches.put(rsrc.getResourceUID(), rsrc);
            }
            results.addAll(bestMatches.values());
        }
        return results;
    }

    private List<SetupResource> resolveSetupResourcesForBasename(String basename) {
        String pattern = basename + "*.*";
        List<SetupResource> result = null;
        try {
            Resource[] matches = this.resourcePatternResolver.getResources(pattern);
            if (matches != null) {
                for (Resource r : matches) {
                    String filename;
                    String contentType;
                    if (result == null) {
                        result = new ArrayList<SetupResource>(8);
                    }
                    if ((contentType = this.fileExtensionContentTypeMapping.get(StringUtils.getFilenameExtension((String)(filename = r.getFilename())))) == null) {
                        contentType = UNKNOWN_CONTENT_TYPE;
                    }
                    result.add(new ResourceSetupResource(r, SetupResourceUtils.baseFilenameForPath(filename), contentType, this.cacheSeconds, this.consumerTypes, this.roles, this.scope));
                }
            }
        }
        catch (IOException e) {
            LOG.error("Error resolving basename [{}]: {}", (Throwable)e);
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public void setConsumerTypes(Set<String> consumerTypes) {
        this.consumerTypes = consumerTypes;
    }

    public void setBasenames(String[] basenames) {
        this.basenames = basenames;
    }

    public void setResourcePatternResolver(ResourcePatternResolver resourcePatternResolver) {
        this.resourcePatternResolver = resourcePatternResolver;
    }

    public void setCacheSeconds(int cacheSeconds) {
        this.cacheSeconds = cacheSeconds;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public void setFileExtensionContentTypeMapping(Map<String, String> fileExtensionContentTypeMapping) {
        this.fileExtensionContentTypeMapping = fileExtensionContentTypeMapping;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public void setScope(SetupResourceScope scope) {
        this.scope = scope;
    }
}

