/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.job;

import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import net.solarnetwork.node.dao.DatumDao;
import net.solarnetwork.node.domain.datum.NodeDatum;
import net.solarnetwork.node.job.JobService;
import net.solarnetwork.node.service.BulkUploadResult;
import net.solarnetwork.node.service.BulkUploadService;
import net.solarnetwork.node.service.support.BaseIdentifiable;
import net.solarnetwork.node.setup.SetupException;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.util.ObjectUtils;

public class DatumDaoBulkUploadJob
extends BaseIdentifiable
implements JobService {
    private final DatumDao dao;
    private final BulkUploadService uploadService;

    public DatumDaoBulkUploadJob(DatumDao dao, BulkUploadService uploadService) {
        this.dao = (DatumDao)ObjectUtils.requireNonNullArgument((Object)dao, (String)"dao");
        this.uploadService = (BulkUploadService)ObjectUtils.requireNonNullArgument((Object)uploadService, (String)"uploadService");
    }

    public String getSettingUid() {
        String uid = this.getUid();
        return uid != null && !uid.isEmpty() ? uid : "net.solarnetwork.node.job.DatumDaoBulkUploadJob";
    }

    public List<SettingSpecifier> getSettingSpecifiers() {
        return Collections.emptyList();
    }

    @Override
    public void executeJobService() throws Exception {
        block12: {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Collecting datum to bulk upload to [{}]", (Object)this.uploadService.getKey());
            }
            List<NodeDatum> toUpload = this.dao.getDatumNotUploaded(this.uploadService.getKey());
            if (this.log.isDebugEnabled()) {
                this.log.debug("Found {} datum to bulk upload to [{}]", (Object)toUpload.size(), (Object)this.uploadService.getKey());
            }
            Instant uploadDate = Instant.now();
            try {
                int count = 0;
                List<BulkUploadResult> results = this.uploadService.uploadBulkDatum(toUpload);
                if (results != null) {
                    for (BulkUploadResult result : results) {
                        String tid = result.getId();
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("Bulk uploaded [{} {}] [{}] and received tid [{}]", new Object[]{result.getDatum().getClass().getSimpleName(), result.getDatum().getTimestamp(), result.getDatum().getSourceId(), tid});
                        }
                        if (tid == null) continue;
                        this.dao.setDatumUploaded(result.getDatum(), uploadDate, this.uploadService.getKey(), tid);
                        ++count;
                    }
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info("Bulk uploaded {} objects to [{}]", (Object)count, (Object)this.uploadService.getKey());
                }
            }
            catch (RuntimeException e) {
                Throwable root = e;
                while (root.getCause() != null) {
                    root = root.getCause();
                }
                if (root instanceof IOException) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn("Network problem posting data ({}): {}", (Object)root.getClass().getSimpleName(), (Object)root.getMessage());
                    }
                }
                if (root instanceof SetupException) {
                    this.log.warn("Unable to post data: {}", (Object)root.getMessage());
                }
                if (!this.log.isErrorEnabled()) break block12;
                this.log.error("Exception posting data", root);
            }
        }
    }
}

