/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.reactor;

import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import net.solarnetwork.domain.InstructionStatus;
import net.solarnetwork.node.reactor.BasicInstruction;
import net.solarnetwork.node.reactor.BasicInstructionStatus;
import net.solarnetwork.node.reactor.Instruction;
import net.solarnetwork.node.reactor.InstructionStatus;

public final class InstructionUtils {
    private InstructionUtils() {
    }

    public static InstructionStatus createStatus(Instruction instruction, InstructionStatus.InstructionState state) {
        return InstructionUtils.createStatus(instruction, state, Instant.now(), null);
    }

    public static InstructionStatus createStatus(Instruction instruction, InstructionStatus.InstructionState state, Map<String, ?> resultParameters) {
        return InstructionUtils.createStatus(instruction, state, Instant.now(), resultParameters);
    }

    public static InstructionStatus createStatus(Instruction instruction, InstructionStatus.InstructionState state, Instant date, Map<String, ?> resultParameters) {
        InstructionStatus status;
        InstructionStatus instructionStatus = status = instruction != null ? instruction.getStatus() : null;
        return status != null ? status.newCopyWithState(state, (Map)resultParameters) : new BasicInstructionStatus(instruction != null ? instruction.getId() : null, state, date != null ? date : Instant.now(), null, resultParameters);
    }

    public static Instruction createLocalInstruction(String topic, Map<String, String> params) {
        BasicInstruction instr = new BasicInstruction(null, topic, Instant.now(), "LOCAL", null);
        if (params != null) {
            for (Map.Entry<String, String> me : params.entrySet()) {
                instr.addParameter(me.getKey(), me.getValue());
            }
        }
        return instr;
    }

    public static Instruction createLocalInstruction(String topic, String paramName, String paramValue) {
        BasicInstruction instr = new BasicInstruction(null, topic, Instant.now(), "LOCAL", null);
        if (paramName != null && paramValue != null) {
            instr.addParameter(paramName, paramValue);
        }
        return instr;
    }

    public static Instruction createSetControlValueLocalInstruction(String controlId, Object controlValue) {
        return InstructionUtils.createLocalInstruction("SetControlParameter", controlId, controlValue.toString());
    }

    public static Map<String, Object> createErrorResultParameters(String message, String code) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(2);
        if (message != null && !message.isEmpty()) {
            result.put("message", message);
        }
        if (code != null && !code.isEmpty()) {
            result.put("code", code);
        }
        return result;
    }
}

