/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.runtime;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.solarnetwork.node.service.SystemHealthService;
import net.solarnetwork.service.PingTest;
import net.solarnetwork.service.PingTestResult;
import net.solarnetwork.service.PingTestResultDisplay;
import net.solarnetwork.service.support.BasicIdentifiable;
import net.solarnetwork.util.ObjectUtils;
import net.solarnetwork.util.StringUtils;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class DefaultSystemHealthService
extends BasicIdentifiable
implements SystemHealthService {
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool((ThreadFactory)new CustomizableThreadFactory("Ping-"));
    private final List<PingTest> tests;

    public DefaultSystemHealthService(List<PingTest> tests) {
        this.tests = (List)ObjectUtils.requireNonNullArgument(tests, (String)"tests");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SystemHealthService.PingTestResults performPingTests(Set<String> pingTestIds) {
        Instant start = Instant.now();
        TreeMap<String, PingTestResultDisplay> results = new TreeMap<String, PingTestResultDisplay>();
        ArrayList<PingTest> runTests = new ArrayList<PingTest>();
        try {
            if (pingTestIds == null || pingTestIds.isEmpty()) {
                runTests.addAll(this.tests);
            } else {
                Pattern[] idExprs = null;
                idExprs = StringUtils.patterns((String[])((String[])pingTestIds.stream().toArray(String[]::new)), (int)2);
                block8: for (PingTest test : this.tests) {
                    for (Pattern p : idExprs) {
                        if (!p.matcher(test.getPingTestId()).find()) continue;
                        runTests.add(test);
                        continue block8;
                    }
                }
            }
            for (final PingTest t : runTests) {
                Instant testStart = Instant.now();
                PingTest.Result pingTestResult = null;
                Future<PingTest.Result> f = null;
                try {
                    f = EXECUTOR.submit(new Callable<PingTest.Result>(){

                        @Override
                        public PingTest.Result call() throws Exception {
                            return t.performPingTest();
                        }
                    });
                    pingTestResult = f.get(t.getPingTestMaximumExecutionMilliseconds(), TimeUnit.MILLISECONDS);
                    results.put(t.getPingTestId(), new PingTestResultDisplay(t, pingTestResult, testStart));
                }
                catch (TimeoutException e) {
                    if (f != null) {
                        f.cancel(true);
                    }
                    pingTestResult = new PingTestResult(false, "Timeout: no result provided within " + t.getPingTestMaximumExecutionMilliseconds() + "ms");
                    results.put(t.getPingTestId(), new PingTestResultDisplay(t, pingTestResult, testStart));
                }
                catch (Throwable e) {
                    Throwable root = e;
                    while (root.getCause() != null) {
                        root = root.getCause();
                    }
                    pingTestResult = new PingTestResult(false, "Exception: " + root.toString());
                    results.put(t.getPingTestId(), new PingTestResultDisplay(t, pingTestResult, testStart));
                    continue;
                    {
                        catch (Throwable throwable) {
                            results.put(t.getPingTestId(), new PingTestResultDisplay(t, pingTestResult, testStart));
                            throw throwable;
                            return new SystemHealthService.PingTestResults(start, results);
                        }
                    }
                }
            }
        }
        catch (PatternSyntaxException e) {
            String msg = this.getMessageSource().getMessage("error.invalidIdPattern", new Object[]{e.getPattern(), e.getMessage()}, "Invalid test ID pattern.", Locale.getDefault());
            PingTestResult r = new PingTestResult(false, msg);
            PingTestResultDisplay rd = new PingTestResultDisplay(null, (PingTest.Result)r, Instant.now());
            results.put("__error.idPattern", rd);
        }
        return new SystemHealthService.PingTestResults(start, results);
    }
}

