/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.service;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.solarnetwork.service.PingTestResultDisplay;

public interface SystemHealthService {
    public PingTestResults performPingTests(Set<String> var1);

    @JsonPropertyOrder(value={"allGood", "date", "results"})
    public static class PingTestResults {
        private final Instant date;
        private final Map<String, PingTestResultDisplay> results;
        private final boolean allGood;

        public PingTestResults(Instant date, Map<String, PingTestResultDisplay> results) {
            this.date = date;
            boolean allOK = true;
            if (results == null) {
                this.results = Collections.emptyMap();
                allOK = false;
            } else {
                this.results = results;
                for (PingTestResultDisplay r : results.values()) {
                    if (r.isSuccess()) continue;
                    allOK = false;
                    break;
                }
            }
            this.allGood = allOK;
        }

        public Map<String, PingTestResultDisplay> getResults() {
            return this.results;
        }

        public Instant getDate() {
            return this.date;
        }

        public boolean isAllGood() {
            return this.allGood;
        }
    }
}

