/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.service.support;

import java.util.ArrayList;
import java.util.List;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.support.BasicTextFieldSettingSpecifier;

public class SerialPortBean
implements Cloneable {
    private static final SerialPortBean DEFAULTS = new SerialPortBean();
    private int baud = 19200;
    private int dataBits = 8;
    private int stopBits = 1;
    private int parity = 0;
    private int flowControl = -1;
    private int receiveThreshold = 40;
    private int receiveTimeout = -1;
    private int receiveFraming = -1;
    private int dtrFlag = 1;
    private int rtsFlag = 0;

    public static List<SettingSpecifier> getDefaultSettingSpecifiers(String prefix) {
        return SerialPortBean.getDefaultSettingSpecifiers(DEFAULTS, prefix);
    }

    public static List<SettingSpecifier> getDefaultSettingSpecifiers(SerialPortBean defaults, String prefix) {
        ArrayList<SettingSpecifier> results = new ArrayList<SettingSpecifier>(20);
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier(prefix + "baud", String.valueOf(defaults.getBaud())));
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier(prefix + "dataBits", String.valueOf(defaults.getDataBits())));
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier(prefix + "stopBits", String.valueOf(defaults.getStopBits())));
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier(prefix + "parity", String.valueOf(defaults.getParity())));
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier(prefix + "flowControl", String.valueOf(defaults.getFlowControl())));
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier(prefix + "receiveThreshold", String.valueOf(defaults.getReceiveThreshold())));
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier(prefix + "receiveTimeout", String.valueOf(defaults.getReceiveTimeout())));
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier(prefix + "receiveFraming", String.valueOf(defaults.getReceiveFraming())));
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier(prefix + "dtrFlag", String.valueOf(defaults.getDtrFlag())));
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier(prefix + "rtsFlag", String.valueOf(defaults.getRtsFlag())));
        return results;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isDtr() {
        return this.dtrFlag > 0;
    }

    public void setDtr(boolean dtr) {
        this.dtrFlag = dtr ? 1 : 0;
    }

    public boolean isRts() {
        return this.rtsFlag > 0;
    }

    public void setRts(boolean rts) {
        this.rtsFlag = rts ? 1 : 0;
    }

    public int getBaud() {
        return this.baud;
    }

    public void setBaud(int baud) {
        this.baud = baud;
    }

    public int getDataBits() {
        return this.dataBits;
    }

    public void setDataBits(int dataBits) {
        this.dataBits = dataBits;
    }

    public int getStopBits() {
        return this.stopBits;
    }

    public void setStopBits(int stopBits) {
        this.stopBits = stopBits;
    }

    public int getParity() {
        return this.parity;
    }

    public void setParity(int parity) {
        this.parity = parity;
    }

    public String getParityString() {
        switch (this.getParity()) {
            case 0: {
                return "none";
            }
            case 1: {
                return "odd";
            }
            case 2: {
                return "even";
            }
        }
        return null;
    }

    public void setParityString(String parity) {
        if ((parity = parity.toLowerCase()).equals("none")) {
            this.setParity(0);
        } else if (parity.equals("odd")) {
            this.setParity(1);
        } else if (parity.equals("even")) {
            this.setParity(2);
        }
    }

    public int getReceiveThreshold() {
        return this.receiveThreshold;
    }

    public void setReceiveThreshold(int receiveThreshold) {
        this.receiveThreshold = receiveThreshold;
    }

    public int getFlowControl() {
        return this.flowControl;
    }

    public void setFlowControl(int flowControl) {
        this.flowControl = flowControl;
    }

    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(int receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public int getReceiveFraming() {
        return this.receiveFraming;
    }

    public void setReceiveFraming(int receiveFraming) {
        this.receiveFraming = receiveFraming;
    }

    public int getDtrFlag() {
        return this.dtrFlag;
    }

    public void setDtrFlag(int dtrFlag) {
        this.dtrFlag = dtrFlag;
    }

    public int getRtsFlag() {
        return this.rtsFlag;
    }

    public void setRtsFlag(int rtsFlag) {
        this.rtsFlag = rtsFlag;
    }
}

