/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.settings;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.solarnetwork.node.Constants;
import net.solarnetwork.node.domain.Setting;
import net.solarnetwork.node.settings.SettingResourceHandler;
import net.solarnetwork.node.settings.SettingsBackup;
import net.solarnetwork.node.settings.SettingsCommand;
import net.solarnetwork.node.settings.SettingsImportOptions;
import net.solarnetwork.settings.FactorySettingSpecifierProvider;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.SettingSpecifierProvider;
import net.solarnetwork.settings.SettingSpecifierProviderFactory;
import net.solarnetwork.util.SearchFilter;
import org.springframework.core.io.Resource;

public interface SettingsService {
    public static final String SYSTEM_PROP_SETTING_RESOURCE_DIR = "sn.rsrc";
    public static final String DEFAULT_SETTING_RESOURCE_DIR = "conf/rsrc";
    public static final String TOPIC_UPDATE_SETTING = "UpdateSetting";
    public static final String PARAM_UPDATE_SETTING_KEY = "key";
    public static final String PARAM_UPDATE_SETTING_TYPE = "type";
    public static final String PARAM_UPDATE_SETTING_VALUE = "value";
    public static final String PARAM_UPDATE_SETTING_FLAGS = "flags";

    public static Path settingResourceDirectory() {
        Path rsrcDir = Paths.get(System.getProperty(SYSTEM_PROP_SETTING_RESOURCE_DIR, DEFAULT_SETTING_RESOURCE_DIR), new String[0]);
        if (rsrcDir.isAbsolute()) {
            return rsrcDir;
        }
        Path dir = Paths.get(Constants.solarNodeHome(), new String[0]);
        return dir.resolve(rsrcDir);
    }

    public List<SettingSpecifierProvider> getProviders();

    public List<SettingSpecifierProvider> getProviders(SearchFilter var1);

    public List<SettingSpecifierProviderFactory> getProviderFactories();

    public List<SettingSpecifierProviderFactory> getProviderFactories(SearchFilter var1);

    public SettingSpecifierProviderFactory getProviderFactory(String var1);

    public void enableProviderFactoryInstance(String var1, String var2);

    public void disableProviderFactoryInstance(String var1, String var2);

    public String addProviderFactoryInstance(String var1);

    default public String addProviderFactoryInstance(String factoryUid, String instanceUid) {
        return this.addProviderFactoryInstance(factoryUid);
    }

    public void deleteProviderFactoryInstance(String var1, String var2);

    public void resetProviderFactoryInstance(String var1, String var2);

    default public void removeProviderFactoryInstances(String factoryUid, Set<String> instanceUids) {
        for (String instanceUid : instanceUids) {
            this.resetProviderFactoryInstance(factoryUid, instanceUid);
            this.deleteProviderFactoryInstance(factoryUid, instanceUid);
        }
    }

    public Map<String, FactorySettingSpecifierProvider> getProvidersForFactory(String var1);

    public Object getSettingValue(SettingSpecifierProvider var1, SettingSpecifier var2);

    public void updateSettings(SettingsCommand var1);

    public List<SettingResourceHandler> getSettingResourceHandlers();

    public SettingResourceHandler getSettingResourceHandler(String var1, String var2);

    public Iterable<Resource> getSettingResources(String var1, String var2, String var3) throws IOException;

    public void importSettingResources(String var1, String var2, String var3, Iterable<Resource> var4) throws IOException;

    public void exportSettingsCSV(Writer var1) throws IOException;

    public List<Setting> getSettings(String var1, String var2);

    public void importSettingsCSV(Reader var1) throws IOException;

    public void importSettingsCSV(Reader var1, SettingsImportOptions var2) throws IOException;

    public SettingsBackup backupSettings();

    public Collection<SettingsBackup> getAvailableBackups();

    public Reader getReaderForBackup(SettingsBackup var1);
}

