/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.settings.support;

import net.solarnetwork.domain.datum.GeneralDatumMetadata;
import net.solarnetwork.node.domain.datum.DatumLocation;
import net.solarnetwork.node.settings.LocationLookupSettingSpecifier;
import net.solarnetwork.settings.MappableSpecifier;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.support.BaseKeyedSettingSpecifier;

public class BasicLocationLookupSettingSpecifier
extends BaseKeyedSettingSpecifier<Long>
implements LocationLookupSettingSpecifier {
    private final DatumLocation location;
    private final String locationType;

    public BasicLocationLookupSettingSpecifier(String key, String locationType, DatumLocation location) {
        super(key, (Object)(location == null ? null : location.getLocationId()));
        this.locationType = locationType;
        this.location = location;
    }

    public SettingSpecifier mappedWithPlaceholer(String template) {
        BasicLocationLookupSettingSpecifier spec = new BasicLocationLookupSettingSpecifier(String.format(template, this.getKey()), this.locationType, this.location);
        spec.setTitle(this.getTitle());
        return spec;
    }

    public SettingSpecifier mappedWithMapper(MappableSpecifier.Mapper mapper) {
        BasicLocationLookupSettingSpecifier spec = new BasicLocationLookupSettingSpecifier(mapper.mapKey(this.getKey()), this.locationType, this.location);
        spec.setTitle(this.getTitle());
        return spec;
    }

    @Override
    public DatumLocation getLocation() {
        return this.location;
    }

    @Override
    public Long getLocationId() {
        return this.location == null ? null : this.location.getLocationId();
    }

    @Override
    public String getLocationName() {
        return this.location == null ? null : this.location.getLocationName();
    }

    @Override
    public String getSourceId() {
        return this.location == null ? null : this.location.getSourceId();
    }

    @Override
    public String getSourceName() {
        return this.location == null ? null : this.location.getSourceName();
    }

    @Override
    public GeneralDatumMetadata getMetadata() {
        return this.location == null ? null : this.location.getMetadata();
    }

    @Override
    public String getLocationTypeKey() {
        String t;
        String string = t = this.locationType == null ? "basic" : this.locationType;
        if (t.endsWith("Location")) {
            t = t.substring(0, t.length() - 8);
        }
        t = t.toLowerCase();
        return t;
    }
}

