/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.settings.support;

import java.util.Comparator;
import java.util.Locale;
import org.springframework.context.MessageSource;

public abstract class MessageSourceMessageComparator<T>
implements Comparator<T> {
    public static final String DEFAULT_MESSAGE_KEY = "title";
    private final Locale locale;
    private final String messageKey;

    public MessageSourceMessageComparator(Locale locale) {
        this(locale, DEFAULT_MESSAGE_KEY);
    }

    public MessageSourceMessageComparator(Locale locale, String messageKey) {
        this.locale = locale;
        this.messageKey = messageKey;
    }

    public int compareMessageKeyValues(MessageSource leftMessageSource, String leftDefault, MessageSource rightMessageSource, String rightDefault) {
        String leftTitle = leftDefault;
        String rightTitle = rightDefault;
        if (leftMessageSource != null) {
            leftTitle = leftMessageSource.getMessage(this.messageKey, null, leftTitle, this.locale);
        }
        if (rightMessageSource != null) {
            rightTitle = rightMessageSource.getMessage(this.messageKey, null, rightTitle, this.locale);
        }
        if (leftTitle == rightTitle) {
            return 0;
        }
        if (leftTitle == null) {
            return -1;
        }
        if (rightTitle == null) {
            return 1;
        }
        return leftTitle.compareToIgnoreCase(rightTitle);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getMessageKey() {
        return this.messageKey;
    }
}

