/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.setup;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.solarnetwork.node.setup.SetupResource;
import org.springframework.util.StringUtils;

public final class SetupResourceUtils {
    public static final Pattern LOCALE_PAT = Pattern.compile("_([a-z]{2,3})(_([A-Z]{2,3}))?(?:\\..*)$");
    public static final Map<String, String> DEFAULT_FILENAME_EXTENSION_CONTENT_TYPES = SetupResourceUtils.defaultFilenameExtensionContentTypeMap();

    private SetupResourceUtils() {
    }

    private static Map<String, String> defaultFilenameExtensionContentTypeMap() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("js", "application/javascript");
        m.put("css", "text/css");
        m.put("html", "text/html");
        m.put("txt", "text/plain");
        m.put("xml", "text/xml");
        return Collections.unmodifiableMap(m);
    }

    public static Locale localeForPath(String path) {
        if (path == null) {
            return null;
        }
        Matcher m = LOCALE_PAT.matcher(path);
        if (m.find()) {
            String lang = m.group(1);
            String country = m.group(3);
            if (country != null) {
                return new Locale(lang, country);
            }
            return SetupResourceUtils.localeForLanguage(lang);
        }
        return null;
    }

    public static String baseFilenameForPath(String path) {
        if (path == null) {
            return null;
        }
        Matcher m = LOCALE_PAT.matcher(path);
        if (m.find()) {
            int end = m.end(2);
            if (end < 0) {
                end = m.end(1);
            }
            String result = StringUtils.getFilename((String)path.substring(0, m.start())) + path.substring(end);
            return result;
        }
        return StringUtils.getFilename((String)path);
    }

    public static Locale localeForLanguage(String lang) {
        if (lang == null) {
            return null;
        }
        if (Locale.ENGLISH.getLanguage().equals(lang)) {
            return Locale.ENGLISH;
        }
        return new Locale(lang);
    }

    public static int localeScore(SetupResource rsrc, Locale desiredLocale, Locale defaultLocale) {
        Locale rsrcLocale;
        if (rsrc == null) {
            return Integer.MIN_VALUE;
        }
        if (defaultLocale == null) {
            defaultLocale = Locale.getDefault();
        }
        if (desiredLocale == null) {
            desiredLocale = defaultLocale;
        }
        if ((rsrcLocale = rsrc.getLocale()) == null) {
            rsrcLocale = defaultLocale;
        }
        if (desiredLocale.equals(rsrcLocale)) {
            return Integer.MAX_VALUE;
        }
        boolean lMatch = desiredLocale.getLanguage().equals(rsrcLocale.getLanguage());
        boolean cMatch = desiredLocale.getCountry().equals(rsrcLocale.getCountry());
        if (lMatch && cMatch) {
            return 2;
        }
        if (lMatch) {
            return 1;
        }
        return -1;
    }
}

