/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.setup;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.solarnetwork.node.setup.SetupResource;
import net.solarnetwork.node.setup.SetupResourceProvider;
import net.solarnetwork.node.setup.SetupResourceUtils;

public class SimpleSetupResourceProvider
implements SetupResourceProvider {
    private Locale defaultLocale = Locale.US;
    private List<SetupResource> resources;

    @Override
    public SetupResource getSetupResource(String resourceUID, Locale locale) {
        if (this.resources == null) {
            return null;
        }
        int bestScore = -1;
        SetupResource bestMatch = null;
        for (SetupResource rsrc : this.resources) {
            if (!resourceUID.equals(rsrc.getResourceUID())) continue;
            int score = SetupResourceUtils.localeScore(rsrc, locale, this.defaultLocale);
            if (score == Integer.MAX_VALUE) {
                return rsrc;
            }
            if (bestMatch != null && score <= bestScore) continue;
            bestScore = score;
            bestMatch = rsrc;
        }
        return bestMatch;
    }

    @Override
    public Collection<SetupResource> getSetupResourcesForConsumer(String consumerType, Locale locale) {
        Collection<SetupResource> result;
        if (this.resources == null) {
            result = Collections.emptyList();
        } else {
            HashMap<String, SetupResource> bestMatches = new HashMap<String, SetupResource>();
            for (SetupResource rsrc : this.resources) {
                SetupResource currMatch;
                Set<String> supported = rsrc.getSupportedConsumerTypes();
                if (supported != null && !supported.contains(consumerType) || SetupResourceUtils.localeScore(currMatch = (SetupResource)bestMatches.get(rsrc.getResourceUID()), locale, this.defaultLocale) >= SetupResourceUtils.localeScore(rsrc, locale, this.defaultLocale)) continue;
                bestMatches.put(rsrc.getResourceUID(), rsrc);
            }
            result = bestMatches.values();
        }
        return result;
    }

    public List<SetupResource> getResources() {
        return this.resources;
    }

    public void setResources(List<SetupResource> resources) {
        this.resources = resources;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }
}

